/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.ListenerMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ListenerWebElement
implements WebElement {
    private final ListenerMapping m_listenerMapping;

    public ListenerWebElement(ListenerMapping listenerMapping) {
        NullArgumentException.validateNotNull(listenerMapping, "Listener mapping");
        this.m_listenerMapping = listenerMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (!WebContainerUtils.isWebContainer(httpService)) {
            throw new UnsupportedOperationException("Internal error: In use HttpService is not an WebContainer (from Pax Web)");
        }
        ((WebContainer)httpService).registerEventListener(this.m_listenerMapping.getListener(), httpContext);
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterEventListener(this.m_listenerMapping.getListener());
        }
    }

    @Override
    public String getHttpContextId() {
        return this.m_listenerMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_listenerMapping).append("}").toString();
    }
}

