/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.element;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.ServletMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ServletWebElement
implements WebElement {
    private ServletMapping m_servletMapping;

    public ServletWebElement(ServletMapping servletMapping) {
        NullArgumentException.validateNotNull(servletMapping, "Servlet mapping");
        this.m_servletMapping = servletMapping;
    }

    @Override
    public void register(HttpService httpService, HttpContext httpContext) throws Exception {
        if (this.m_servletMapping.getAlias() != null) {
            httpService.registerServlet(this.m_servletMapping.getAlias(), this.m_servletMapping.getServlet(), DictionaryUtils.adapt(this.m_servletMapping.getInitParams()), httpContext);
        } else if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).registerServlet(this.m_servletMapping.getServlet(), this.m_servletMapping.getServletName(), this.m_servletMapping.getUrlPatterns(), DictionaryUtils.adapt(this.m_servletMapping.getInitParams()), httpContext);
        }
    }

    @Override
    public void unregister(HttpService httpService, HttpContext httpContext) {
        if (this.m_servletMapping.getAlias() != null) {
            httpService.unregister(this.m_servletMapping.getAlias());
        } else if (WebContainerUtils.isWebContainer(httpService)) {
            ((WebContainer)httpService).unregisterServlet(this.m_servletMapping.getServlet());
        }
    }

    @Override
    public String getHttpContextId() {
        return this.m_servletMapping.getHttpContextId();
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.m_servletMapping).append("}").toString();
    }
}

