/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpContextTracker<T>
extends ServiceTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTracker.class);
    private final ExtenderContext m_extenderContext;

    AbstractHttpContextTracker(ExtenderContext extenderContext, BundleContext bundleContext, Class<? extends T> ... classes) {
        super(AbstractHttpContextTracker.validateBundleContext(bundleContext), AbstractHttpContextTracker.createFilter(bundleContext, classes), null);
        NullArgumentException.validateNotNull(extenderContext, "Extender context");
        this.m_extenderContext = extenderContext;
    }

    private static Filter createFilter(BundleContext bundleContext, Class ... classes) {
        StringBuilder filter = new StringBuilder();
        if (classes != null) {
            if (classes.length > 1) {
                filter.append("(|");
            }
            for (Class clazz : classes) {
                filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            if (classes.length > 1) {
                filter.append(")");
            }
        }
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public Object addingService(ServiceReference serviceReference) {
        LOGGER.debug("Service available " + serviceReference);
        Object registered = super.addingService(serviceReference);
        HttpContextMapping mapping = this.createHttpContextMapping(serviceReference, registered);
        if (mapping != null) {
            WebApplication webApplication = this.m_extenderContext.getWebApplication(serviceReference.getBundle(), mapping.getHttpContextId());
            webApplication.setHttpContextMapping(mapping);
            return mapping;
        }
        super.remove(serviceReference);
        return null;
    }

    public void removedService(ServiceReference serviceReference, Object unpublished) {
        LOGGER.debug("Service removed " + serviceReference);
        super.removedService(serviceReference, unpublished);
        HttpContextMapping mapping = (HttpContextMapping)unpublished;
        WebApplication webApplication = this.m_extenderContext.getWebApplication(serviceReference.getBundle(), mapping.getHttpContextId());
        webApplication.setHttpContextMapping(null);
    }

    abstract HttpContextMapping createHttpContextMapping(ServiceReference var1, T var2);
}

