/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.HashMap;
import javax.servlet.Filter;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultFilterMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTracker
extends AbstractTracker<Filter, FilterWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterTracker.class);

    public FilterTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext, Filter.class);
    }

    @Override
    FilterWebElement createWebElement(ServiceReference serviceReference, Filter published) {
        Object urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] urlPatterns = null;
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = (String[])urlPatternsProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid url pattern property (must be String or String[])");
                return null;
            }
        }
        Object servletNamesProp = serviceReference.getProperty("servletNames");
        String[] servletNAmes = null;
        if (servletNamesProp != null) {
            if (servletNamesProp instanceof String) {
                servletNAmes = new String[]{(String)servletNamesProp};
            } else if (servletNamesProp instanceof String[]) {
                servletNAmes = (String[])servletNamesProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid servlet names property (must be String or String[])");
                return null;
            }
        }
        if (urlPatterns == null && servletNAmes == null) {
            LOG.warn("Registered filter [" + published + "] did not contain a valid url pattern or servlet names property");
            return null;
        }
        Object httpContextId = serviceReference.getProperty("httpContext.id");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered filter [" + published + "] did not contain a valid http context id");
            return null;
        }
        String[] initParamKeys = serviceReference.getPropertyKeys();
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String key : initParamKeys) {
            try {
                String value = serviceReference.getProperty(key) == null ? "" : serviceReference.getProperty(key).toString();
                initParams.put(key, value);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        DefaultFilterMapping mapping = new DefaultFilterMapping();
        mapping.setFilter(published);
        mapping.setHttpContextId((String)httpContextId);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setServletNames(servletNAmes);
        mapping.setInitParams(initParams);
        return new FilterWebElement(mapping);
    }
}

