/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.EventListener;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ListenerWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultListenerMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerTracker
extends AbstractTracker<EventListener, ListenerWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerTracker.class);

    public ListenerTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext, EventListener.class);
    }

    @Override
    ListenerWebElement createWebElement(ServiceReference serviceReference, EventListener published) {
        Object httpContextId = serviceReference.getProperty("httpContext.id");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered listener [" + published + "] did not contain a valid http context id");
            return null;
        }
        DefaultListenerMapping mapping = new DefaultListenerMapping();
        mapping.setHttpContextId((String)httpContextId);
        mapping.setListener(published);
        return new ListenerWebElement(mapping);
    }
}

