/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.ops4j.pax.web.extender.whiteboard.ErrorPageMapping;
import org.ops4j.pax.web.extender.whiteboard.FilterMapping;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.JspMapping;
import org.ops4j.pax.web.extender.whiteboard.ListenerMapping;
import org.ops4j.pax.web.extender.whiteboard.ResourceMapping;
import org.ops4j.pax.web.extender.whiteboard.ServletMapping;
import org.ops4j.pax.web.extender.whiteboard.WelcomeFileMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ErrorPageWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.JspWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ListenerWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ResourceWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.ServletWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WelcomeFileWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ErrorPageMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.FilterTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.HttpContextTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.JspMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ListenerTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ResourceMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.ServletTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.WelcomeFileMappingTracker;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ExtenderContext extenderContext;
    private List<ServiceTracker<?, ?>> trackers;

    public void start(BundleContext bundleContext) throws Exception {
        this.extenderContext = new ExtenderContext();
        this.extenderContext.open(bundleContext);
        this.trackers = new ArrayList();
        this.trackHttpContexts(bundleContext);
        this.trackServlets(bundleContext);
        this.trackResources(bundleContext);
        if (WebContainerUtils.WEB_CONATAINER_AVAILABLE) {
            this.trackFilters(bundleContext);
            this.trackListeners(bundleContext);
            this.trackJspMappings(bundleContext);
            this.trackErrorPages(bundleContext);
            this.trackWelcomeFiles(bundleContext);
        } else {
            LOG.warn("Filters tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("Event Listeners tracking has been disabled as the WebContainer (Pax Web) is not available");
            LOG.warn("JSP mappings tracking has been disabled as the WebContainer (Pax Web) is not available");
        }
        LOG.debug("Pax Web Extender started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (ServiceTracker<?, ?> tracker : this.trackers) {
            tracker.close();
        }
        this.trackers = null;
        this.extenderContext.close(bundleContext);
        LOG.debug("Pax Web Extender stopped");
    }

    private void trackHttpContexts(BundleContext bundleContext) {
        ServiceTracker<HttpContext, HttpContextMapping> httpContextTracker = HttpContextTracker.createTracker(this.extenderContext, bundleContext);
        httpContextTracker.open();
        this.trackers.add(0, httpContextTracker);
        ServiceTracker<HttpContextMapping, HttpContextMapping> httpContextMappingTracker = HttpContextMappingTracker.createTracker(this.extenderContext, bundleContext);
        httpContextMappingTracker.open();
        this.trackers.add(0, httpContextMappingTracker);
    }

    private void trackServlets(BundleContext bundleContext) {
        ServiceTracker<Servlet, ServletWebElement> servletTracker = ServletTracker.createTracker(this.extenderContext, bundleContext, Servlet.class);
        servletTracker.open();
        this.trackers.add(0, servletTracker);
        ServiceTracker<HttpServlet, ServletWebElement> httpServletTracker = ServletTracker.createTracker(this.extenderContext, bundleContext, HttpServlet.class);
        httpServletTracker.open();
        this.trackers.add(0, servletTracker);
        ServiceTracker<ServletMapping, ServletWebElement> servletMappingTracker = ServletMappingTracker.createTracker(this.extenderContext, bundleContext);
        servletMappingTracker.open();
        this.trackers.add(0, servletMappingTracker);
    }

    private void trackResources(BundleContext bundleContext) {
        ServiceTracker<ResourceMapping, ResourceWebElement> resourceMappingTracker = ResourceMappingTracker.createTracker(this.extenderContext, bundleContext);
        resourceMappingTracker.open();
        this.trackers.add(0, resourceMappingTracker);
    }

    private void trackFilters(BundleContext bundleContext) {
        ServiceTracker<Filter, FilterWebElement> filterTracker = FilterTracker.createTracker(this.extenderContext, bundleContext);
        filterTracker.open();
        this.trackers.add(0, filterTracker);
        ServiceTracker<FilterMapping, FilterWebElement> filterMappingTracker = FilterMappingTracker.createTracker(this.extenderContext, bundleContext);
        filterMappingTracker.open();
        this.trackers.add(0, filterMappingTracker);
    }

    private void trackListeners(BundleContext bundleContext) {
        ServiceTracker<EventListener, ListenerWebElement> listenerTracker = ListenerTracker.createTracker(this.extenderContext, bundleContext);
        listenerTracker.open();
        this.trackers.add(0, listenerTracker);
        ServiceTracker<ListenerMapping, ListenerWebElement> listenerMappingTracker = ListenerMappingTracker.createTracker(this.extenderContext, bundleContext);
        listenerMappingTracker.open();
        this.trackers.add(0, listenerMappingTracker);
    }

    private void trackJspMappings(BundleContext bundleContext) {
        ServiceTracker<JspMapping, JspWebElement> jspMappingTracker = JspMappingTracker.createTracker(this.extenderContext, bundleContext);
        jspMappingTracker.open();
        this.trackers.add(0, jspMappingTracker);
    }

    private void trackWelcomeFiles(BundleContext bundleContext) {
        ServiceTracker<WelcomeFileMapping, WelcomeFileWebElement> welcomeFileTracker = WelcomeFileMappingTracker.createTracker(this.extenderContext, bundleContext);
        welcomeFileTracker.open();
        this.trackers.add(0, welcomeFileTracker);
    }

    private void trackErrorPages(BundleContext bundleContext) {
        ServiceTracker<ErrorPageMapping, ErrorPageWebElement> errorPagesTracker = ErrorPageMappingTracker.createTracker(this.extenderContext, bundleContext);
        errorPagesTracker.open();
        this.trackers.add(0, errorPagesTracker);
    }
}

