/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceTracker
extends ServiceTracker<HttpService, HttpService> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceTracker.class);
    private Collection<HttpServiceListener> listeners = new CopyOnWriteArrayList<HttpServiceListener>();
    private HttpService httpService;
    private Lock lock = new ReentrantLock();

    public HttpServiceTracker(BundleContext bundleContext) {
        super(HttpServiceTracker.validateBundleContext(bundleContext), HttpService.class, null);
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Bundle context cannot be null");
        }
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpService addingService(ServiceReference<HttpService> serviceReference) {
        LOG.debug("HttpService available {}", serviceReference);
        this.lock.lock();
        HttpService addedHttpService = null;
        try {
            if (this.httpService != null) {
                HttpService httpService = (HttpService)super.addingService(serviceReference);
                return httpService;
            }
            addedHttpService = this.httpService = (HttpService)super.addingService(serviceReference);
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.listeners) {
            try {
                listener.available(addedHttpService);
            }
            catch (Exception ignore) {
                LOG.error("Cannot register", (Throwable)ignore);
            }
        }
        return addedHttpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<HttpService> serviceReference, HttpService service) {
        LOG.debug("HttpService removed {}", serviceReference);
        this.lock.lock();
        HttpService removedHttpService = null;
        try {
            super.removedService(serviceReference, (Object)service);
            if (this.httpService != service) {
                return;
            }
            removedHttpService = this.httpService;
            this.httpService = null;
        }
        finally {
            this.lock.unlock();
        }
        for (HttpServiceListener listener : this.listeners) {
            listener.unavailable(removedHttpService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(HttpServiceListener listener) {
        this.listeners.add(listener);
        this.lock.lock();
        try {
            if (this.httpService != null) {
                try {
                    listener.available(this.httpService);
                }
                catch (Exception ignore) {
                    LOG.error("Cannot register", (Throwable)ignore);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(HttpServiceListener listener) {
        this.listeners.remove(listener);
        this.lock.lock();
        try {
            if (this.httpService != null) {
                listener.unavailable(this.httpService);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

