/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.HttpServiceListener;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements HttpServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplication.class);
    private final List<WebElement> webElements = new ArrayList<WebElement>();
    private final ReadWriteLock webElementsLock;
    private final ReadWriteLock httpServiceLock = new ReentrantReadWriteLock();
    private HttpContextMapping httpContextMapping;
    private HttpService httpService;
    private HttpContext httpContext;

    public WebApplication() {
        this.webElementsLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.httpServiceLock.readLock().lock();
        try {
            this.registerWebElement(webElement);
        }
        finally {
            this.httpServiceLock.readLock().unlock();
        }
        this.webElementsLock.writeLock().lock();
        try {
            this.webElements.add(webElement);
        }
        finally {
            this.webElementsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.webElementsLock.writeLock().lock();
        try {
            this.webElements.remove(webElement);
        }
        finally {
            this.webElementsLock.writeLock().unlock();
        }
        this.httpServiceLock.readLock().lock();
        try {
            this.unregisterWebElement(webElement);
        }
        finally {
            this.httpServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void available(HttpService httpServiceIn) throws Exception {
        NullArgumentException.validateNotNull(httpServiceIn, "Http service");
        this.httpServiceLock.writeLock().lock();
        try {
            if (this.httpService != null) {
                this.unavailable(this.httpService);
            }
            this.httpService = httpServiceIn;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    public boolean hasHttpContextMapping() {
        return this.httpContextMapping != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpContextMapping(HttpContextMapping httpContextMapping) {
        this.httpServiceLock.writeLock().lock();
        try {
            if (this.hasHttpContextMapping()) {
                this.unregisterHttpContext();
            }
            this.httpContextMapping = httpContextMapping;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    private void unregisterHttpContext() {
        if (this.httpContext != null) {
            this.unregisterWebElements();
            this.httpContext = null;
        }
    }

    private void registerHttpContext() {
        if (this.httpContextMapping != null && this.httpService != null) {
            this.httpContext = this.httpContextMapping.getHttpContext();
            if (this.httpContext == null) {
                this.httpContext = this.httpService.createDefaultHttpContext();
            }
            if (WebContainerUtils.isWebContainer(this.httpService)) {
                HashMap<String, String> contextparams = new HashMap<String, String>();
                if (this.httpContextMapping.getPath() != null) {
                    contextparams.put("webapp.context", this.httpContextMapping.getPath());
                }
                if (this.httpContextMapping.getParameters() != null) {
                    String connectors;
                    contextparams.putAll(this.httpContextMapping.getParameters());
                    String virtualHosts = (String)contextparams.remove("httpContext.virtualhosts");
                    if (virtualHosts != null) {
                        ((WebContainer)this.httpService).setVirtualHosts(this.convertToList(virtualHosts), this.httpContext);
                    }
                    if ((connectors = (String)contextparams.remove("httpContext.connectors")) != null) {
                        ((WebContainer)this.httpService).setConnectors(this.convertToList(connectors), this.httpContext);
                    }
                }
                ((WebContainer)this.httpService).setContextParam(DictionaryUtils.adapt(contextparams), this.httpContext);
            }
            this.registerWebElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWebElements() {
        this.webElementsLock.readLock().lock();
        try {
            if (this.httpService != null && this.httpContext != null) {
                for (WebElement registerer : this.webElements) {
                    this.registerWebElement(registerer);
                }
            }
        }
        finally {
            this.webElementsLock.readLock().unlock();
        }
    }

    private List<String> convertToList(String elementListAsString) {
        LinkedList<String> elementList = new LinkedList<String>();
        if (elementListAsString != null && elementListAsString.length() > 0) {
            String[] elementArray;
            for (String element : elementArray = elementListAsString.split(",")) {
                elementList.add(element.trim());
            }
        }
        return elementList;
    }

    private void registerWebElement(WebElement registerer) {
        try {
            if (this.httpService != null && this.httpContext != null) {
                registerer.register(this.httpService, this.httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error("Registration skipped for [" + registerer + "] due to error during registration", (Throwable)ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unavailable(HttpService httpServiceIn) {
        NullArgumentException.validateNotNull(httpServiceIn, "Http service");
        this.httpServiceLock.writeLock().lock();
        try {
            if (httpServiceIn != this.httpService) {
                throw new IllegalStateException("Unavailable http service [" + httpServiceIn + "] is not equal with prior available http service [" + this.httpService + "]");
            }
            this.unregisterWebElements();
            this.httpService = null;
            this.httpContext = null;
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWebElements() {
        this.webElementsLock.readLock().lock();
        try {
            if (this.httpService != null && this.httpContext != null) {
                for (WebElement registerer : this.webElements) {
                    this.unregisterWebElement(registerer);
                }
            }
        }
        finally {
            this.webElementsLock.readLock().unlock();
        }
    }

    private void unregisterWebElement(WebElement registerer) {
        if (this.httpService != null && this.httpContext != null) {
            registerer.unregister(this.httpService, this.httpContext);
        }
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.httpContextMapping).append("}").toString();
    }
}

