/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpContextTracker<T>
implements ServiceTrackerCustomizer<T, HttpContextMapping> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTracker.class);
    private final ExtenderContext extenderContext;
    private final BundleContext bundleContext;

    AbstractHttpContextTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        NullArgumentException.validateNotNull(extenderContext, "Extender context");
        this.extenderContext = extenderContext;
        this.bundleContext = AbstractHttpContextTracker.validateBundleContext(bundleContext);
    }

    protected final ServiceTracker<T, HttpContextMapping> create(Class<? extends T> trackedClass) {
        return new ServiceTracker(this.bundleContext, AbstractHttpContextTracker.createFilter(this.bundleContext, trackedClass), (ServiceTrackerCustomizer)this);
    }

    private static Filter createFilter(BundleContext bundleContext, Class<?> ... classes) {
        StringBuilder filter = new StringBuilder();
        if (classes != null) {
            if (classes.length > 1) {
                filter.append("(|");
            }
            for (Class<?> clazz : classes) {
                filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
            }
            if (classes.length > 1) {
                filter.append(")");
            }
        }
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public HttpContextMapping addingService(ServiceReference<T> serviceReference) {
        LOGGER.debug("Service available " + serviceReference);
        Object registered = this.bundleContext.getService(serviceReference);
        HttpContextMapping mapping = this.createHttpContextMapping(serviceReference, registered);
        if (mapping != null) {
            WebApplication webApplication = this.extenderContext.getWebApplication(serviceReference.getBundle(), mapping.getHttpContextId());
            webApplication.setHttpContextMapping(mapping);
            return mapping;
        }
        return null;
    }

    public void modifiedService(ServiceReference<T> reference, HttpContextMapping service) {
    }

    public void removedService(ServiceReference<T> serviceReference, HttpContextMapping unpublished) {
        LOGGER.debug("Service removed " + serviceReference);
        HttpContextMapping mapping = unpublished;
        WebApplication webApplication = this.extenderContext.getWebApplication(serviceReference.getBundle(), mapping.getHttpContextId());
        webApplication.setHttpContextMapping(null);
    }

    abstract HttpContextMapping createHttpContextMapping(ServiceReference<T> var1, T var2);
}

