/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.HttpContextMapping;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.util.DictionaryUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.WebContainerUtils;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableService;
import org.ops4j.pax.web.extender.whiteboard.internal.util.tracker.ReplaceableServiceListener;
import org.ops4j.pax.web.service.WebContainer;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplication
implements ReplaceableServiceListener<HttpService> {
    private static final Logger LOG = LoggerFactory.getLogger(WebApplication.class);
    private final Bundle bundle;
    private final String httpContextId;
    private final List<WebElement> webElements;
    private final ReadWriteLock webElementsLock;
    private final ReadWriteLock httpServiceLock;
    private HttpContextMapping httpContextMapping;
    private ReplaceableService<HttpService> httpServiceTracker;
    private HttpService httpService;
    private HttpContext httpContext;

    public WebApplication(Bundle bundle, String httpContextId) {
        this.bundle = bundle;
        this.httpContextId = httpContextId;
        this.webElements = new ArrayList<WebElement>();
        this.httpServiceLock = new ReentrantReadWriteLock();
        this.webElementsLock = new ReentrantReadWriteLock();
        this.httpServiceTracker = new ReplaceableService<HttpService>(bundle.getBundleContext(), HttpService.class, this);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getHttpContextId() {
        return this.httpContextId;
    }

    public void start() {
        this.httpServiceTracker.start();
    }

    public void stop() {
        this.httpServiceTracker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebElement(WebElement webElement) {
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.httpServiceLock.readLock().lock();
        try {
            this.registerWebElement(webElement);
        }
        finally {
            this.httpServiceLock.readLock().unlock();
        }
        this.webElementsLock.writeLock().lock();
        try {
            this.webElements.add(webElement);
        }
        finally {
            this.webElementsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWebElement(WebElement webElement) {
        boolean empty;
        NullArgumentException.validateNotNull(webElement, "Registerer");
        this.webElementsLock.writeLock().lock();
        try {
            this.webElements.remove(webElement);
            empty = this.webElements.isEmpty();
        }
        finally {
            this.webElementsLock.writeLock().unlock();
        }
        this.httpServiceLock.readLock().lock();
        try {
            this.unregisterWebElement(webElement);
        }
        finally {
            this.httpServiceLock.readLock().unlock();
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceChanged(HttpService oldService, HttpService newService) {
        this.httpServiceLock.writeLock().lock();
        try {
            this.unregisterWebElements();
            this.httpService = newService;
            this.httpContext = null;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    public boolean hasHttpContextMapping() {
        return this.httpContextMapping != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHttpContextMapping(HttpContextMapping httpContextMapping) {
        this.httpServiceLock.writeLock().lock();
        try {
            if (this.hasHttpContextMapping()) {
                this.unregisterHttpContext();
            }
            this.httpContextMapping = httpContextMapping;
            this.registerHttpContext();
        }
        finally {
            this.httpServiceLock.writeLock().unlock();
        }
    }

    private void unregisterHttpContext() {
        if (this.httpContext != null) {
            this.unregisterWebElements();
            this.httpContext = null;
        }
    }

    private void registerHttpContext() {
        if (this.httpContextMapping != null && this.httpService != null) {
            this.httpContext = this.httpContextMapping.getHttpContext();
            if (this.httpContext == null) {
                this.httpContext = this.httpContextId != null && WebContainerUtils.isWebContainer(this.httpService) ? ((WebContainer)this.httpService).createDefaultHttpContext(this.httpContextId) : this.httpService.createDefaultHttpContext();
            }
            if (WebContainerUtils.isWebContainer(this.httpService)) {
                HashMap<String, String> contextparams = new HashMap<String, String>();
                if (this.httpContextMapping.getPath() != null) {
                    contextparams.put("webapp.context", this.httpContextMapping.getPath());
                }
                if (this.httpContextMapping.getParameters() != null) {
                    String connectors;
                    contextparams.putAll(this.httpContextMapping.getParameters());
                    String virtualHosts = (String)contextparams.remove("httpContext.virtualhosts");
                    if (virtualHosts != null) {
                        ((WebContainer)this.httpService).setVirtualHosts(this.convertToList(virtualHosts), this.httpContext);
                    }
                    if ((connectors = (String)contextparams.remove("httpContext.connectors")) != null) {
                        ((WebContainer)this.httpService).setConnectors(this.convertToList(connectors), this.httpContext);
                    }
                }
                ((WebContainer)this.httpService).setContextParam(DictionaryUtils.adapt(contextparams), this.httpContext);
            }
            this.registerWebElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWebElements() {
        this.webElementsLock.readLock().lock();
        try {
            if (this.httpService != null && this.httpContext != null) {
                for (WebElement registerer : this.webElements) {
                    this.registerWebElement(registerer);
                }
            }
        }
        finally {
            this.webElementsLock.readLock().unlock();
        }
    }

    private List<String> convertToList(String elementListAsString) {
        LinkedList<String> elementList = new LinkedList<String>();
        if (elementListAsString != null && elementListAsString.length() > 0) {
            String[] elementArray;
            for (String element : elementArray = elementListAsString.split(",")) {
                elementList.add(element.trim());
            }
        }
        return elementList;
    }

    private void registerWebElement(WebElement registerer) {
        try {
            if (this.httpService != null && this.httpContext != null) {
                registerer.register(this.httpService, this.httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error("Registration skipped for [" + registerer + "] due to error during registration", (Throwable)ignore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterWebElements() {
        this.webElementsLock.readLock().lock();
        try {
            if (this.httpService != null && this.httpContext != null) {
                for (WebElement registerer : this.webElements) {
                    this.unregisterWebElement(registerer);
                }
            }
        }
        finally {
            this.webElementsLock.readLock().unlock();
        }
    }

    private void unregisterWebElement(WebElement registerer) {
        if (this.httpService != null && this.httpContext != null) {
            registerer.unregister(this.httpService, this.httpContext);
        }
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("mapping=").append(this.httpContextMapping).append("}").toString();
    }
}

