/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Filter;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.element.FilterWebElement;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractTracker;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultFilterMapping;
import org.ops4j.pax.web.utils.FilterAnnotationScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTracker
extends AbstractTracker<Filter, FilterWebElement> {
    private static final Logger LOG = LoggerFactory.getLogger(FilterTracker.class);

    private FilterTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        super(extenderContext, bundleContext);
    }

    public static ServiceTracker<Filter, FilterWebElement> createTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        return new FilterTracker(extenderContext, bundleContext).create(Filter.class);
    }

    @Override
    FilterWebElement createWebElement(ServiceReference<Filter> serviceReference, Filter published) {
        String[] urlPatternsProp = serviceReference.getProperty("urlPatterns");
        String[] urlPatterns = null;
        FilterAnnotationScanner annotationScan = new FilterAnnotationScanner(published.getClass());
        if (annotationScan.scanned.booleanValue()) {
            if (urlPatternsProp == null) {
                urlPatternsProp = annotationScan.urlPatterns;
            } else {
                HashSet<String> patterns = new HashSet<String>();
                patterns.addAll(Arrays.asList(annotationScan.urlPatterns));
                if (urlPatternsProp instanceof String && ((String)urlPatternsProp).trim().length() != 0) {
                    patterns.add((String)urlPatternsProp);
                } else if (urlPatternsProp instanceof String[]) {
                    patterns.addAll(Arrays.asList(urlPatternsProp));
                }
                urlPatternsProp = patterns.toArray(new String[patterns.size()]);
            }
        }
        if (urlPatternsProp != null) {
            if (urlPatternsProp instanceof String) {
                urlPatterns = new String[]{(String)urlPatternsProp};
            } else if (urlPatternsProp instanceof String[]) {
                urlPatterns = urlPatternsProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid url pattern property (must be String or String[])");
                return null;
            }
        }
        String[] servletNamesProp = serviceReference.getProperty("servletNames");
        if (annotationScan.scanned.booleanValue()) {
            if (servletNamesProp == null) {
                servletNamesProp = annotationScan.servletNames;
            } else {
                HashSet<String> patterns = new HashSet<String>();
                patterns.addAll(Arrays.asList(annotationScan.servletNames));
                if (servletNamesProp instanceof String && ((String)servletNamesProp).trim().length() != 0) {
                    patterns.add((String)servletNamesProp);
                } else if (servletNamesProp instanceof String[]) {
                    patterns.addAll(Arrays.asList(servletNamesProp));
                }
                servletNamesProp = patterns.toArray(new String[patterns.size()]);
            }
        }
        String[] servletNames = null;
        if (servletNamesProp != null) {
            if (servletNamesProp instanceof String) {
                servletNames = new String[]{(String)servletNamesProp};
            } else if (servletNamesProp instanceof String[]) {
                servletNames = servletNamesProp;
            } else {
                LOG.warn("Registered filter [" + published + "] has an invalid servlet names property (must be String or String[])");
                return null;
            }
        }
        if (urlPatterns == null && servletNames == null) {
            LOG.warn("Registered filter [" + published + "] did not contain a valid url pattern or servlet names property");
            return null;
        }
        Object httpContextId = serviceReference.getProperty("httpContext.id");
        if (!(httpContextId == null || httpContextId instanceof String && ((String)httpContextId).trim().length() != 0)) {
            LOG.warn("Registered filter [" + published + "] did not contain a valid http context id");
            return null;
        }
        String[] initParamKeys = serviceReference.getPropertyKeys();
        HashMap<String, String> initParams = new HashMap<String, String>();
        for (String string : initParamKeys) {
            try {
                String value = serviceReference.getProperty(string) == null ? "" : serviceReference.getProperty(string).toString();
                initParams.put(string, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (annotationScan.scanned.booleanValue()) {
            for (String string : annotationScan.webInitParams) {
                initParams.put(string.name(), string.value());
            }
        }
        DefaultFilterMapping mapping = new DefaultFilterMapping();
        mapping.setFilter(published);
        mapping.setHttpContextId((String)httpContextId);
        mapping.setUrlPatterns(urlPatterns);
        mapping.setServletNames(servletNames);
        mapping.setInitParams(initParams);
        return new FilterWebElement(mapping);
    }
}

