/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JettyServerWrapper
extends Server {
    private static final Log LOG = LogFactory.getLog(JettyServerWrapper.class);
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final ServerModel m_serverModel;
    private final Map<HttpContext, ServletContextHandler> m_contexts;
    private Map<String, Object> m_contextAttributes;
    private Integer m_sessionTimeout;
    private String m_sessionCookie;
    private String m_sessionUrl;
    private String m_sessionWorkerName;
    private File serverConfigDir;
    private ServiceRegistration servletContextService;

    JettyServerWrapper(ServerModel serverModel) {
        this.m_serverModel = serverModel;
        this.m_contexts = new IdentityHashMap<HttpContext, ServletContextHandler>();
        this.setHandler((Handler)new HandlerCollection(true));
    }

    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, String sessionWorkerName) {
        this.m_contextAttributes = attributes;
        this.m_sessionTimeout = sessionTimeout;
        this.m_sessionCookie = sessionCookie;
        this.m_sessionUrl = sessionUrl;
        this.m_sessionWorkerName = sessionWorkerName;
    }

    ServletContextHandler getContext(HttpContext httpContext) {
        return this.m_contexts.get(httpContext);
    }

    ServletContextHandler getOrCreateContext(Model model) {
        ServletContextHandler context = this.m_contexts.get(model.getContextModel().getHttpContext());
        if (context == null) {
            context = this.addContext(model);
            this.m_contexts.put(model.getContextModel().getHttpContext(), context);
        }
        return context;
    }

    void removeContext(HttpContext httpContext) {
        try {
            if (this.servletContextService != null) {
                this.servletContextService.unregister();
            }
        }
        catch (IllegalStateException e) {
            LOG.info("ServletContext service already removed");
        }
        ((HandlerCollection)this.getHandler()).removeHandler((Handler)this.getContext(httpContext));
        this.m_contexts.remove(httpContext);
    }

    private ServletContextHandler addContext(Model model) {
        String workerName;
        String sessionUrl;
        String sessionCookie;
        Bundle bundle = model.getContextModel().getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext(bundle);
        HttpServiceContext context = new HttpServiceContext((HandlerContainer)this.getHandler(), model.getContextModel().getContextParams(), this.getContextAttributes(bundleContext), model.getContextModel().getContextName(), model.getContextModel().getHttpContext(), model.getContextModel().getAccessControllerContext());
        context.setClassLoader(model.getContextModel().getClassLoader());
        Integer sessionTimeout = model.getContextModel().getSessionTimeout();
        if (sessionTimeout == null) {
            sessionTimeout = this.m_sessionTimeout;
        }
        if ((sessionCookie = model.getContextModel().getSessionCookie()) == null) {
            sessionCookie = this.m_sessionCookie;
        }
        if ((sessionUrl = model.getContextModel().getSessionUrl()) == null) {
            sessionUrl = this.m_sessionUrl;
        }
        if ((workerName = model.getContextModel().getSessionWorkerName()) == null) {
            workerName = this.m_sessionWorkerName;
        }
        this.configureSessionManager(context, sessionTimeout, sessionCookie, sessionUrl, workerName);
        if (model.getContextModel().getRealmName() != null && model.getContextModel().getAuthMethod() != null) {
            this.configureSecurity(context, model.getContextModel().getRealmName(), model.getContextModel().getAuthMethod(), model.getContextModel().getFormLoginPage(), model.getContextModel().getFormErrorPage());
        }
        LOG.debug("Added servlet context: " + (Object)((Object)context));
        if (this.isStarted()) {
            try {
                LOG.debug("(Re)starting servlet contexts...");
                Handler serverHandler = this.getHandler();
                if (!serverHandler.isStarted() && !serverHandler.isStarting()) {
                    serverHandler.start();
                }
                if (!context.isStarted() && !context.isStarting()) {
                    context.start();
                    LOG.debug("Registering ServletContext as service. ");
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
                    Dictionary headers = bundle.getHeaders();
                    String version = (String)headers.get("Bundle-Version");
                    if (version != null && version.length() > 0) {
                        ((Dictionary)properties).put("osgi.web.version", version);
                    }
                    String webContextPath = (String)headers.get(WEB_CONTEXT_PATH);
                    String webappContext = (String)headers.get("Webapp-Context");
                    ContextHandler.Context servletContext = context.getServletContext();
                    if ("/".equalsIgnoreCase(context.getContextPath()) && (webContextPath == null || webappContext == null)) {
                        webContextPath = context.getContextPath();
                    }
                    String string = webContextPath = webContextPath != null ? webContextPath : webappContext;
                    if (webContextPath != null && !webContextPath.startsWith("/")) {
                        webContextPath = "/" + webContextPath;
                    }
                    if (webContextPath == null) {
                        LOG.warn("osgi.web.contextpath couldn't be set, it's not configured");
                    }
                    this.servletContextService = bundleContext.registerService(ServletContext.class.getName(), (Object)servletContext, properties);
                    LOG.debug("ServletContext registered as service. ");
                }
            }
            catch (Exception ignore) {
                LOG.error("Could not start the servlet context for http context [" + model.getContextModel().getHttpContext() + "]", ignore);
            }
        }
        return context;
    }

    private void configureSecurity(ServletContextHandler context, String realmName, String authMethod, String formLoginPage, String formErrorPage) {
        SecurityHandler securityHandler = context.getSecurityHandler();
        FormAuthenticator authenticator = null;
        if ("FORM".equals(authMethod)) {
            authenticator = new FormAuthenticator();
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", formLoginPage);
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", formErrorPage);
        } else if ("BASIC".equals(authMethod)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equals(authMethod)) {
            authenticator = new DigestAuthenticator();
        } else if ("CLIENT_CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else if ("CLIENT-CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else {
            LOG.warn("UNKNOWN AUTH METHOD: " + authMethod);
        }
        securityHandler.setAuthenticator((Authenticator)authenticator);
        securityHandler.setRealmName(realmName);
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.m_contextAttributes != null) {
            attributes.putAll(this.m_contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionManager(ServletContextHandler context, Integer minutes, String cookie, String url, String workerName) {
        SessionManager sessionManager;
        LOG.debug("configureSessionManager for context [" + context + "] using - timeout:" + minutes + ", cookie:" + cookie + ", url:" + url + ", workerName:" + workerName);
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            if (minutes != null) {
                sessionManager.setMaxInactiveInterval(minutes * 60);
                LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
            }
            if (cookie != null) {
                sessionManager.setSessionCookie(cookie);
                LOG.debug("Session cookie set to " + cookie + " for context [" + context + "]");
            }
            if (url != null) {
                sessionManager.setSessionIdPathParameterName(url);
                LOG.debug("Session URL set to " + url + " for context [" + context + "]");
            }
            if (workerName != null) {
                SessionIdManager sessionIdManager = this.getSessionIdManager(sessionManager);
                if (sessionIdManager == null) {
                    sessionIdManager = new HashSessionIdManager();
                    this.setSessionIdManager(sessionManager, sessionIdManager);
                }
                if (sessionIdManager instanceof HashSessionIdManager) {
                    HashSessionIdManager s = (HashSessionIdManager)sessionIdManager;
                    s.setWorkerName(workerName);
                    LOG.debug("Worker name set to " + workerName + " for context [" + context + "]");
                }
            }
        }
    }

    private void setSessionIdManager(SessionManager sessionManager, SessionIdManager idManager) {
        try {
            sessionManager.getClass().getMethod("setSessionIdManager", SessionIdManager.class).invoke((Object)sessionManager, idManager);
        }
        catch (Exception e) {
            try {
                sessionManager.getClass().getMethod("setIdManager", SessionIdManager.class).invoke((Object)sessionManager, idManager);
            }
            catch (Exception e1) {
                LOG.error("Cannot set the SessionIdManager on [" + sessionManager + "]", e1);
            }
        }
    }

    private SessionIdManager getSessionIdManager(SessionManager sessionManager) {
        try {
            return (SessionIdManager)sessionManager.getClass().getMethod("getSessionIdManager", new Class[0]).invoke((Object)sessionManager, new Object[0]);
        }
        catch (Exception e) {
            try {
                return (SessionIdManager)sessionManager.getClass().getMethod("getIdManager", new Class[0]).invoke((Object)sessionManager, new Object[0]);
            }
            catch (Exception e1) {
                LOG.error("Cannot get the SessionIdManager on [" + sessionManager + "]", e1);
                return null;
            }
        }
    }

    public void setServerConfigDir(File serverConfigDir) {
        this.serverConfigDir = serverConfigDir;
    }

    public File getServerConfigDir() {
        return this.serverConfigDir;
    }
}

