/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JettyServerImpl
implements JettyServer {
    private static final Log LOG = LogFactory.getLog(JettyServerImpl.class);
    private final JettyServerWrapper m_server;

    JettyServerImpl(ServerModel serverModel) {
        this.m_server = new JettyServerWrapper(serverModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LOG.debug("Starting " + this);
        try {
            URL jettyResource = this.getClass().getResource("/jetty.xml");
            File serverConfigurationFile = this.getServerConfigDir();
            if (serverConfigurationFile != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found server configuration file: " + serverConfigurationFile);
                }
                if (!serverConfigurationFile.isDirectory() && serverConfigurationFile.canRead()) {
                    String fileName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("server config dir is readable and exists");
                    }
                    if ((fileName = serverConfigurationFile.getName()).equalsIgnoreCase("jetty.xml")) {
                        jettyResource = serverConfigurationFile.toURI().toURL();
                    }
                }
            }
            if (jettyResource != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    LOG.debug("Configure using resource " + jettyResource);
                    XmlConfiguration configuration = new XmlConfiguration(jettyResource);
                    Method method = XmlConfiguration.class.getMethod("configure", Object.class);
                    method.invoke((Object)configuration, new Object[]{this.m_server});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
            }
            this.m_server.start();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("Stopping " + this);
        try {
            this.m_server.stop();
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    @Override
    public void addConnector(Connector connector) {
        LOG.info(String.format("Pax Web available at [%s]:[%s]", connector.getHost() == null ? "0.0.0.0" : connector.getHost(), connector.getPort()));
        this.m_server.addConnector(connector);
    }

    @Override
    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, String workerName) {
        this.m_server.configureContext(attributes, sessionTimeout, sessionCookie, sessionUrl, workerName);
    }

    @Override
    public void addServlet(ServletModel model) {
        LOG.debug("Adding servlet [" + model + "]");
        final ServletMapping mapping = new ServletMapping();
        mapping.setServletName(model.getName());
        mapping.setPathSpecs(model.getUrlPatterns());
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final ServletHolder holder = new ServletHolder(model.getServlet());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addServlet(holder);
                    servletHandler.addServletMapping(mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during servlet registration", e);
        }
    }

    @Override
    public void removeServlet(ServletModel model) {
        ServletHolder holder;
        LOG.debug("Removing servlet [" + model + "]");
        boolean removed = false;
        ServletContextHandler context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ServletHandler servletHandler = context.getServletHandler();
        Object[] holders = servletHandler.getServlets();
        if (holders != null && (holder = servletHandler.getServlet(model.getName())) != null) {
            servletHandler.setServlets((ServletHolder[])LazyList.removeFromArray((Object[])holders, (Object)holder));
            Object[] mappings = servletHandler.getServletMappings();
            if (mappings != null) {
                ServletMapping mapping = null;
                for (ServletMapping servletMapping : mappings) {
                    if (!holder.getName().equals(servletMapping.getServletName())) continue;
                    mapping = servletMapping;
                    break;
                }
                if (mapping != null) {
                    servletHandler.setServletMappings((ServletMapping[])LazyList.removeFromArray((Object[])mappings, mapping));
                    removed = true;
                }
            }
            if (holder.isStarted()) {
                try {
                    ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            holder.stop();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    LOG.warn("Exception during unregistering of servlet [" + model + "]");
                }
            }
        }
        this.removeContext(model.getContextModel().getHttpContext());
        if (!removed) {
            throw new IllegalStateException(model + " was not found");
        }
    }

    @Override
    public void addEventListener(EventListenerModel model) {
        this.m_server.getOrCreateContext((Model)model).addEventListener(model.getEventListener());
    }

    @Override
    public void removeEventListener(EventListenerModel model) {
        ServletContextHandler context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ArrayList<EventListener> listeners = new ArrayList<EventListener>(Arrays.asList(context.getEventListeners()));
        listeners.remove(model.getEventListener());
        context.setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        this.m_server.removeContext(httpContext);
    }

    @Override
    public void addFilter(FilterModel model) {
        LOG.debug("Adding filter model [" + model + "]");
        final FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(model.getName());
        if (model.getUrlPatterns() != null && model.getUrlPatterns().length > 0) {
            mapping.setPathSpecs(model.getUrlPatterns());
        }
        if (model.getServletNames() != null && model.getServletNames().length > 0) {
            mapping.setServletNames(model.getServletNames());
        }
        int dispatcher = 0;
        for (String d : model.getDispatcher()) {
            dispatcher |= FilterMapping.dispatch((String)d).ordinal();
        }
        mapping.setDispatches(dispatcher);
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final FilterHolder holder = new FilterHolder(model.getFilter());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addFilter(holder, mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during filter registration", e);
        }
    }

    @Override
    public void removeFilter(FilterModel model) {
        LOG.debug("Removing filter model [" + model + "]");
        ServletContextHandler context = this.m_server.getContext(model.getContextModel().getHttpContext());
        ServletHandler servletHandler = context.getServletHandler();
        Object[] filterMappings = servletHandler.getFilterMappings();
        Object[] newFilterMappings = null;
        for (FilterMapping filterMapping : filterMappings) {
            if (!filterMapping.getFilterName().equals(model.getName())) continue;
            if (newFilterMappings == null) {
                newFilterMappings = filterMappings;
            }
            newFilterMappings = (FilterMapping[])LazyList.removeFromArray((Object[])newFilterMappings, (Object)filterMapping);
        }
        servletHandler.setFilterMappings(newFilterMappings);
        final FilterHolder filterHolder = servletHandler.getFilter(model.getName());
        Object[] filterHolders = servletHandler.getFilters();
        FilterHolder[] newFilterHolders = (FilterHolder[])LazyList.removeFromArray((Object[])filterHolders, (Object)filterHolder);
        servletHandler.setFilters(newFilterHolders);
        if (filterHolder.isStarted()) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        filterHolder.stop();
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                LOG.warn("Exception during unregistering of filter [" + filterHolder.getFilter() + "]");
            }
        }
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        HashMap<String, String> errorPages = errorPageHandler.getErrorPages();
        if (errorPages == null) {
            errorPages = new HashMap<String, String>();
        }
        errorPages.put(model.getError(), model.getLocation());
        errorPageHandler.setErrorPages(errorPages);
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        Map errorPages = errorPageHandler.getErrorPages();
        if (errorPages != null) {
            errorPages.remove(model.getError());
            if (errorPages.size() == 0) {
                errorPageHandler.setErrorPages(null);
            }
        }
    }

    @Override
    public void addSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        String mappingMethod = model.getMapping();
        String constraintName = model.getConstraintName();
        String url = model.getUrl();
        String dataConstraint = model.getDataConstraint();
        List roles = model.getRoles();
        boolean authentication = model.isAuthentication();
        ConstraintMapping newConstraintMapping = new ConstraintMapping();
        newConstraintMapping.setMethod(mappingMethod);
        newConstraintMapping.setPathSpec(url);
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(authentication);
        constraint.setName(constraintName);
        constraint.setRoles(roles.toArray(new String[roles.size()]));
        if (dataConstraint == null || "NONE".equals(dataConstraint)) {
            constraint.setDataConstraint(0);
        } else if ("INTEGRAL".equals(dataConstraint)) {
            constraint.setDataConstraint(1);
        } else if ("CONFIDENTIAL".equals(dataConstraint)) {
            constraint.setDataConstraint(2);
        } else {
            LOG.warn("Unknown user-data-constraint:" + dataConstraint);
            constraint.setDataConstraint(2);
        }
        newConstraintMapping.setConstraint(constraint);
        ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(newConstraintMapping);
    }

    @Override
    public void removeSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        ServletContextHandler context = this.m_server.getOrCreateContext((Model)model);
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        List constraintMappings = ((ConstraintSecurityHandler)securityHandler).getConstraintMappings();
        for (ConstraintMapping constraintMapping : constraintMappings) {
            boolean urlMatch = constraintMapping.getPathSpec().equalsIgnoreCase(model.getUrl());
            boolean methodMatch = constraintMapping.getMethod().equalsIgnoreCase(model.getMapping());
            if (!urlMatch || !methodMatch) continue;
            constraintMappings.remove(constraintMapping);
        }
    }

    public String toString() {
        return JettyServerImpl.class.getSimpleName() + "{" + "}";
    }

    @Override
    public void setServerConfigDir(File serverConfigDir) {
        this.m_server.setServerConfigDir(serverConfigDir);
    }

    @Override
    public File getServerConfigDir() {
        return this.m_server.getServerConfigDir();
    }
}

