/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServerHandlerCollection;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerWrapper
extends Server {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerWrapper.class);
    private final ServerModel serverModel;
    private final Map<HttpContext, ServletContextInfo> contexts = new IdentityHashMap<HttpContext, ServletContextInfo>();
    private Map<String, Object> contextAttributes;
    private Integer sessionTimeout;
    private String sessionCookie;
    private String sessionDomain;
    private String sessionPath;
    private String sessionUrl;
    private String sessionWorkerName;
    private Boolean lazyLoad;
    private String storeDirectory;
    private File serverConfigDir;
    private URL serverConfigURL;
    private Boolean sessionCookieHttpOnly;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    JettyServerWrapper(ServerModel serverModel) {
        this.serverModel = serverModel;
        this.setHandler((Handler)new JettyServerHandlerCollection(serverModel));
    }

    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, Boolean sessionCookieHttpOnly, String sessionWorkerName, Boolean lazyLoad, String storeDirectory) {
        this.contextAttributes = attributes;
        this.sessionTimeout = sessionTimeout;
        this.sessionCookie = sessionCookie;
        this.sessionUrl = sessionUrl;
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
        this.sessionWorkerName = sessionWorkerName;
        this.lazyLoad = lazyLoad;
        this.storeDirectory = storeDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpServiceContext getContext(HttpContext httpContext) {
        this.readLock.lock();
        try {
            ServletContextInfo servletContextInfo = this.contexts.get(httpContext);
            if (servletContextInfo != null) {
                HttpServiceContext httpServiceContext = servletContextInfo.getHandler();
                return httpServiceContext;
            }
            HttpServiceContext httpServiceContext = null;
            return httpServiceContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    HttpServiceContext getOrCreateContext(Model model) {
        return this.getOrCreateContext(model.getContextModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpServiceContext getOrCreateContext(ContextModel model) {
        ServletContextInfo context;
        block9: {
            HttpContext httpContext = model.getHttpContext();
            context = null;
            try {
                this.readLock.lock();
                if (this.contexts.containsKey(httpContext)) {
                    context = this.contexts.get(httpContext);
                    break block9;
                }
                try {
                    this.readLock.unlock();
                    this.writeLock.lock();
                    if (!this.contexts.containsKey(httpContext)) {
                        LOG.debug("Creating new ServletContextHandler for HTTP context [{}] and model [{}]", (Object)httpContext, (Object)model);
                        context = new ServletContextInfo(this.addContext(model));
                        this.contexts.put(httpContext, context);
                    } else {
                        context = this.contexts.get(httpContext);
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        return context.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContext(HttpContext httpContext) {
        ServletContextInfo context;
        block12: {
            try {
                this.readLock.lock();
                context = this.contexts.get(httpContext);
                if (context == null) {
                    return;
                }
                int nref = context.decrementRefCount();
                if (nref <= 0) {
                    try {
                        this.readLock.unlock();
                        this.writeLock.lock();
                        LOG.debug("Removing ServletContextHandler for HTTP context [{}].", (Object)httpContext);
                        context = this.contexts.remove(httpContext);
                        break block12;
                    }
                    finally {
                        this.readLock.lock();
                        this.writeLock.unlock();
                    }
                }
                LOG.debug("ServletContextHandler for HTTP context [{}] referenced [{}] times.", (Object)httpContext, (Object)nref);
                return;
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (context != null) {
            HttpServiceContext sch = context.getHandler();
            sch.unregisterService();
            try {
                sch.stop();
            }
            catch (Throwable t) {
                // empty catch block
            }
            sch.getServletHandler().setServer(null);
            sch.getSecurityHandler().setServer(null);
            sch.getSessionHandler().setServer(null);
            sch.getErrorHandler().setServer(null);
            ((HandlerCollection)this.getHandler()).removeHandler((Handler)sch);
            sch.destroy();
        }
    }

    private HttpServiceContext addContext(ContextModel model) {
        String workerName;
        Boolean modelSessionCookieHttpOnly;
        String modelSessionUrl;
        String modelSessionPath;
        String modelSessionDomain;
        String modelSessionCookie;
        Bundle bundle = model.getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext((Bundle)bundle);
        HttpServiceContext context = new HttpServiceContext((HandlerContainer)this.getHandler(), model.getContextParams(), this.getContextAttributes(bundleContext), model.getContextName(), model.getHttpContext(), model.getAccessControllerContext(), model.getContainerInitializers(), model.getJettyWebXmlURL(), model.getVirtualHosts(), model.getConnectors());
        context.setClassLoader(model.getClassLoader());
        Integer modelSessionTimeout = model.getSessionTimeout();
        if (modelSessionTimeout == null) {
            modelSessionTimeout = this.sessionTimeout;
        }
        if ((modelSessionCookie = model.getSessionCookie()) == null) {
            modelSessionCookie = this.sessionCookie;
        }
        if ((modelSessionDomain = model.getSessionDomain()) == null) {
            modelSessionDomain = this.sessionDomain;
        }
        if ((modelSessionPath = model.getSessionPath()) == null) {
            modelSessionPath = this.sessionPath;
        }
        if ((modelSessionUrl = model.getSessionUrl()) == null) {
            modelSessionUrl = this.sessionUrl;
        }
        if ((modelSessionCookieHttpOnly = model.getSessionCookieHttpOnly()) == null) {
            modelSessionCookieHttpOnly = this.sessionCookieHttpOnly;
        }
        if ((workerName = model.getSessionWorkerName()) == null) {
            workerName = this.sessionWorkerName;
        }
        this.configureSessionManager(context, modelSessionTimeout, modelSessionCookie, modelSessionDomain, modelSessionPath, modelSessionUrl, modelSessionCookieHttpOnly, workerName, this.lazyLoad, this.storeDirectory);
        if (model.getRealmName() != null && model.getAuthMethod() != null) {
            this.configureSecurity(context, model.getRealmName(), model.getAuthMethod(), model.getFormLoginPage(), model.getFormErrorPage());
        }
        LOG.debug("Added servlet context: " + (Object)((Object)context));
        if (this.isStarted()) {
            try {
                LOG.debug("(Re)starting servlet contexts...");
                Handler serverHandler = this.getHandler();
                if (!serverHandler.isStarted() && !serverHandler.isStarting()) {
                    serverHandler.start();
                }
                if (!context.isStarted() && !context.isStarting()) {
                    LOG.debug("Registering ServletContext as service. ");
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
                    Dictionary headers = bundle.getHeaders();
                    String version = (String)headers.get("Bundle-Version");
                    if (version != null && version.length() > 0) {
                        ((Dictionary)properties).put("osgi.web.version", version);
                    }
                    ContextHandler.Context servletContext = context.getServletContext();
                    String webContextPath = context.getContextPath();
                    ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
                    context.registerService(bundleContext, properties);
                    LOG.debug("ServletContext registered as service. ");
                }
            }
            catch (Exception ignore) {
                LOG.error("Could not start the servlet context for http context [" + model.getHttpContext() + "]", (Throwable)ignore);
            }
        }
        return context;
    }

    private void configureSecurity(ServletContextHandler context, String realmName, String authMethod, String formLoginPage, String formErrorPage) {
        SecurityHandler securityHandler = context.getSecurityHandler();
        FormAuthenticator authenticator = null;
        if ("FORM".equals(authMethod)) {
            authenticator = new FormAuthenticator();
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", formLoginPage);
            securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", formErrorPage);
        } else if ("BASIC".equals(authMethod)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equals(authMethod)) {
            authenticator = new DigestAuthenticator();
        } else if ("CLIENT_CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else if ("CLIENT-CERT".equals(authMethod)) {
            authenticator = new ClientCertAuthenticator();
        } else if ("SPNEGO".equals(authMethod)) {
            authenticator = new SpnegoAuthenticator();
        } else {
            LOG.warn("UNKNOWN AUTH METHOD: " + authMethod);
        }
        securityHandler.setAuthenticator((Authenticator)authenticator);
        securityHandler.setRealmName(realmName);
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.contextAttributes != null) {
            attributes.putAll(this.contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }

    private void configureSessionManager(ServletContextHandler context, Integer minutes, String cookie, String domain, String path, String url, Boolean cookieHttpOnly, String workerName, Boolean lazyLoad, String storeDirectory) {
        SessionManager sessionManager;
        LOG.debug("configureSessionManager for context [" + context + "] using - timeout:" + minutes + ", cookie:" + cookie + ", url:" + url + ", cookieHttpOnly:" + cookieHttpOnly + ", workerName:" + workerName + ", lazyLoad:" + lazyLoad + ", storeDirectory: " + storeDirectory);
        SessionHandler sessionHandler = context.getSessionHandler();
        if (sessionHandler != null && (sessionManager = sessionHandler.getSessionManager()) != null) {
            if (minutes != null) {
                sessionManager.setMaxInactiveInterval(minutes * 60);
                LOG.debug("Session timeout set to " + minutes + " minutes for context [" + context + "]");
            }
            if (cookie == null || "none".equals(cookie)) {
                if (sessionManager instanceof AbstractSessionManager) {
                    ((AbstractSessionManager)sessionManager).setUsingCookies(false);
                    LOG.debug("Session cookies disabled for context [" + context + "]");
                } else {
                    LOG.debug("SessionManager isn't of type AbstractSessionManager therefore using cookies unchanged!");
                }
            } else {
                sessionManager.getSessionCookieConfig().setName(cookie);
                LOG.debug("Session cookie set to " + cookie + " for context [" + context + "]");
                sessionManager.getSessionCookieConfig().setHttpOnly(cookieHttpOnly.booleanValue());
                LOG.debug("Session cookieHttpOnly set to " + cookieHttpOnly + " for context [" + context + "]");
            }
            if (domain != null && domain.length() > 0) {
                sessionManager.getSessionCookieConfig().setDomain(domain);
                LOG.debug("Session domain set to " + domain + " for context [" + context + "]");
            }
            if (path != null && path.length() > 0) {
                sessionManager.getSessionCookieConfig().setPath(path);
                LOG.debug("Session path set to " + path + " for context [" + context + "]");
            }
            if (url != null) {
                sessionManager.setSessionIdPathParameterName(url);
                LOG.debug("Session URL set to " + url + " for context [" + context + "]");
            }
            if (workerName != null) {
                SessionIdManager sessionIdManager = sessionManager.getSessionIdManager();
                if (sessionIdManager == null) {
                    sessionIdManager = new HashSessionIdManager();
                    sessionManager.setSessionIdManager(sessionIdManager);
                }
                if (sessionIdManager instanceof AbstractSessionIdManager) {
                    AbstractSessionIdManager s = (AbstractSessionIdManager)sessionIdManager;
                    s.setWorkerName(workerName);
                    LOG.debug("Worker name set to " + workerName + " for context [" + context + "]");
                }
            }
            if (lazyLoad != null) {
                LOG.debug("is LazyLoad active? {}", (Object)lazyLoad);
                if (sessionManager instanceof HashSessionManager) {
                    ((HashSessionManager)sessionManager).setLazyLoad(lazyLoad.booleanValue());
                }
            }
            if (storeDirectory != null) {
                LOG.debug("storeDirectoy set to: {}", (Object)storeDirectory);
                if (sessionManager instanceof HashSessionManager) {
                    File storeDir = null;
                    try {
                        storeDir = new File(storeDirectory);
                        ((HashSessionManager)sessionManager).setStoreDirectory(storeDir);
                    }
                    catch (IOException e) {
                        LOG.warn("IOException while trying to set the StoreDirectory on the session Manager", (Throwable)e);
                    }
                }
            }
        }
    }

    public void setServerConfigDir(File serverConfigDir) {
        this.serverConfigDir = serverConfigDir;
    }

    public File getServerConfigDir() {
        return this.serverConfigDir;
    }

    public URL getServerConfigURL() {
        return this.serverConfigURL;
    }

    public void setServerConfigURL(URL serverConfigURL) {
        this.serverConfigURL = serverConfigURL;
    }

    private static final class ServletContextInfo {
        private final HttpServiceContext handler;
        private final AtomicInteger refCount = new AtomicInteger(1);

        public ServletContextInfo(HttpServiceContext handler) {
            this.handler = handler;
        }

        public int incrementRefCount() {
            return this.refCount.incrementAndGet();
        }

        public int decrementRefCount() {
            return this.refCount.decrementAndGet();
        }

        public HttpServiceContext getHandler() {
            return this.handler;
        }
    }
}

