/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.resource.Resource;
import org.osgi.service.http.HttpContext;

class ResourceServlet
extends HttpServlet {
    private final HttpContext m_httpContext;
    private final String m_contextName;
    private final String m_alias;
    private final String m_name;

    ResourceServlet(HttpContext httpContext, String contextName, String alias, String name) {
        this.m_httpContext = httpContext;
        this.m_contextName = "/" + contextName;
        this.m_alias = alias;
        this.m_name = "/".equals(name) ? "" : name;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out;
        String mapping;
        if (this.m_contextName.equals(this.m_alias)) {
            mapping = this.m_name + request.getRequestURI();
        } else {
            mapping = request.getRequestURI().replaceFirst(this.m_contextName, "/");
            mapping = mapping.replaceFirst(this.m_alias, this.m_name);
        }
        URL url = this.m_httpContext.getResource(mapping);
        if (url == null) {
            response.sendError(404);
            return;
        }
        Resource resource = Resource.newResource(url, false);
        if (!resource.exists()) {
            response.sendError(404);
            return;
        }
        if (resource.isDirectory()) {
            response.sendError(403);
            return;
        }
        String mimeType = this.m_httpContext.getMimeType(mapping);
        if (mimeType == null) {
            try {
                mimeType = url.openConnection().getContentType();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if ((out = response.getOutputStream()) != null) {
            if (out instanceof HttpConnection.Output) {
                ((HttpConnection.Output)out).sendContent(resource.getInputStream());
            } else {
                resource.writeTo(out, 0L, resource.length());
            }
        }
        response.setStatus(200);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "context=" + this.m_contextName + ",alias=" + this.m_alias + ",name=" + this.m_name + "}";
    }
}

