/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextModel
extends Identity {
    private final HttpContext m_httpContext;
    private final ClassLoader m_classLoader;
    private final Map<String, String> m_contextParams;
    private String m_contextName;
    private Filter m_welcomeFilesFilter;
    private AccessControlContext m_accessControllerContext;
    private Servlet m_jspServlet;
    private Integer m_sessionTimeout;
    private String m_sessionCookie;
    private String m_sessionUrl;
    private String m_sessionWorkerName;
    private final Bundle m_bundle;

    public ContextModel(HttpContext httpContext, Bundle bundle, ClassLoader classLoader) {
        this.m_bundle = bundle;
        NullArgumentException.validateNotNull(httpContext, "Http context");
        NullArgumentException.validateNotNull(classLoader, "Class loader");
        this.m_classLoader = classLoader;
        this.m_httpContext = httpContext;
        this.m_contextParams = new HashMap<String, String>();
        this.m_contextName = "";
        this.m_accessControllerContext = AccessController.getContext();
    }

    public HttpContext getHttpContext() {
        return this.m_httpContext;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public void setContextParams(Dictionary contextParams) {
        if (contextParams != null && !contextParams.isEmpty()) {
            this.m_contextParams.clear();
            Enumeration keys = contextParams.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = contextParams.get(key);
                if (!(key instanceof String) || !(value instanceof String)) {
                    throw new IllegalArgumentException("Context params keys and values must be Strings");
                }
                this.m_contextParams.put((String)key, (String)value);
            }
        }
        this.m_contextName = this.m_contextParams.get("webapp.context");
        this.m_contextName = this.m_contextName != null ? this.m_contextName.trim() : "";
    }

    public Map<String, String> getContextParams() {
        return this.m_contextParams;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public Servlet getJspServlet() {
        return this.m_jspServlet;
    }

    public void setJspServlet(Servlet jspServlet) {
        this.m_jspServlet = jspServlet;
    }

    public AccessControlContext getAccessControllerContext() {
        return this.m_accessControllerContext;
    }

    public Filter getWelcomeFilesFilter() {
        return this.m_welcomeFilesFilter;
    }

    public void setWelcomeFilesFilter(Filter welcomeFilesFilter) {
        this.m_welcomeFilesFilter = welcomeFilesFilter;
    }

    public Integer getSessionTimeout() {
        return this.m_sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.m_sessionTimeout = sessionTimeout;
    }

    public String getSessionCookie() {
        return this.m_sessionCookie;
    }

    public void setSessionCookie(String sessionCookie) {
        this.m_sessionCookie = sessionCookie;
    }

    public String getSessionUrl() {
        return this.m_sessionUrl;
    }

    public void setSessionUrl(String sessionUrl) {
        this.m_sessionUrl = sessionUrl;
    }

    public String getSessionWorkerName() {
        return this.m_sessionWorkerName;
    }

    public void setSessionWorkerName(String sessionWorkerName) {
        this.m_sessionWorkerName = sessionWorkerName;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",name=" + this.m_contextName + ",httpContext=" + this.m_httpContext + ",contextParams=" + this.m_contextParams + "}";
    }
}

