/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;

public class ServiceModel {
    private final Map<String, ServletModel> m_aliasMapping = new HashMap<String, ServletModel>();
    private final Map<Servlet, ServletModel> m_servletModels = new HashMap<Servlet, ServletModel>();
    private final Map<Filter, FilterModel> m_filterModels = new LinkedHashMap<Filter, FilterModel>();
    private final Map<EventListener, EventListenerModel> m_eventListenerModels = new HashMap<EventListener, EventListenerModel>();
    private final Map<String, ErrorPageModel> m_errorPageModels = new HashMap<String, ErrorPageModel>();
    private final Map<HttpContext, ContextModel> m_contextModels = new HashMap<HttpContext, ContextModel>();

    public synchronized ServletModel getServletModelWithAlias(String alias) {
        NullArgumentException.validateNotEmpty(alias, "Alias");
        return this.m_aliasMapping.get(alias);
    }

    public synchronized void addServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.m_aliasMapping.put(model.getAlias(), model);
        }
        this.m_servletModels.put(model.getServlet(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized void removeServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.m_aliasMapping.remove(model.getAlias());
        }
        this.m_servletModels.remove(model.getServlet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletModel removeServlet(Servlet servlet) {
        Map<Servlet, ServletModel> map = this.m_servletModels;
        synchronized (map) {
            ServletModel model = this.m_servletModels.get(servlet);
            if (model == null) {
                throw new IllegalArgumentException("Servlet [" + servlet + " is not currently registered in any context");
            }
            this.m_servletModels.remove(servlet);
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListenerModel(EventListenerModel model) {
        Map<EventListener, EventListenerModel> map = this.m_eventListenerModels;
        synchronized (map) {
            if (this.m_eventListenerModels.containsKey(model.getEventListener())) {
                throw new IllegalArgumentException("Listener [" + model.getEventListener() + "] already registered.");
            }
            this.m_eventListenerModels.put(model.getEventListener(), model);
            this.addContextModel(model.getContextModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListenerModel removeEventListener(EventListener listener) {
        Map<EventListener, EventListenerModel> map = this.m_eventListenerModels;
        synchronized (map) {
            EventListenerModel model = this.m_eventListenerModels.get(listener);
            if (model == null) {
                throw new IllegalArgumentException("Listener [" + listener + " is not currently registered in any context");
            }
            this.m_eventListenerModels.remove(listener);
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterModel(FilterModel model) {
        Map<Filter, FilterModel> map = this.m_filterModels;
        synchronized (map) {
            if (this.m_filterModels.containsKey(model.getFilter())) {
                throw new IllegalArgumentException("Filter [" + model.getFilter() + "] is already registered.");
            }
            this.m_filterModels.put(model.getFilter(), model);
            this.addContextModel(model.getContextModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterModel removeFilter(Filter filter) {
        Map<Filter, FilterModel> map = this.m_filterModels;
        synchronized (map) {
            FilterModel model = this.m_filterModels.get(filter);
            if (model == null) {
                throw new IllegalArgumentException("Filter [" + filter + " is not currently registered in any context");
            }
            this.m_filterModels.remove(filter);
            return model;
        }
    }

    public ServletModel[] getServletModels() {
        Collection<ServletModel> models = this.m_servletModels.values();
        return models.toArray(new ServletModel[models.size()]);
    }

    public EventListenerModel[] getEventListenerModels() {
        Collection<EventListenerModel> models = this.m_eventListenerModels.values();
        return models.toArray(new EventListenerModel[models.size()]);
    }

    public FilterModel[] getFilterModels() {
        Collection<FilterModel> models = this.m_filterModels.values();
        return models.toArray(new FilterModel[models.size()]);
    }

    public ErrorPageModel[] getErrorPageModels() {
        Collection<ErrorPageModel> models = this.m_errorPageModels.values();
        return models.toArray(new ErrorPageModel[models.size()]);
    }

    public void addContextModel(ContextModel contextModel) {
        if (!this.m_contextModels.containsKey(contextModel.getHttpContext())) {
            this.m_contextModels.put(contextModel.getHttpContext(), contextModel);
        }
    }

    public ContextModel[] getContextModels() {
        Collection<ContextModel> contextModels = this.m_contextModels.values();
        if (contextModels == null || contextModels.size() == 0) {
            return new ContextModel[0];
        }
        return contextModels.toArray(new ContextModel[contextModels.size()]);
    }

    public ContextModel getContextModel(HttpContext httpContext) {
        return this.m_contextModels.get(httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorPageModel(ErrorPageModel model) {
        Map<String, ErrorPageModel> map = this.m_errorPageModels;
        synchronized (map) {
            String key = model.getError() + "|" + model.getContextModel().getId();
            if (this.m_errorPageModels.containsKey(key)) {
                throw new IllegalArgumentException("Error page for [" + model.getError() + "] already registered.");
            }
            this.m_errorPageModels.put(key, model);
            this.addContextModel(model.getContextModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorPageModel removeErrorPage(String error, ContextModel contextModel) {
        Map<String, ErrorPageModel> map = this.m_errorPageModels;
        synchronized (map) {
            String key = error + "|" + contextModel.getId();
            ErrorPageModel model = this.m_errorPageModels.get(key);
            if (model == null) {
                throw new IllegalArgumentException("Error page for [" + error + "] cannot be found in the provided http context");
            }
            this.m_errorPageModels.remove(key);
            return model;
        }
    }

    public boolean canBeConfigured() {
        return this.m_servletModels.size() == 0 && this.m_filterModels.size() == 0 && this.m_eventListenerModels.size() == 0 && this.m_errorPageModels.size() == 0;
    }
}

