/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.WebContainerConstants;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterModel
extends Model {
    private static final Set<String> VALID_DISPATCHER_VALUES = new HashSet<String>(){
        {
            this.add("request");
            this.add("forward");
            this.add("include");
            this.add("error");
        }
    };
    private final Filter m_filter;
    private final String[] m_urlPatterns;
    private final String[] m_servletNames;
    private final Map<String, String> m_initParams;
    private final String m_name;
    private final Set<String> m_dispatcher = new HashSet<String>();

    public FilterModel(ContextModel contextModel, Filter filter, String[] urlPatterns, String[] servletNames, Dictionary initParams) {
        super(contextModel);
        NullArgumentException.validateNotNull(filter, "Filter");
        if (urlPatterns == null && servletNames == null) {
            throw new IllegalArgumentException("Registered filter must have at least one url pattern or servlet name mapping");
        }
        this.m_filter = filter;
        this.m_urlPatterns = Path.normalizePatterns(urlPatterns);
        this.m_servletNames = servletNames;
        this.m_initParams = FilterModel.convertToMap(initParams);
        String name = this.m_initParams.get("filter-name");
        if (name == null) {
            name = this.getId();
        }
        this.m_name = name;
        this.setupDispatcher();
    }

    private void setupDispatcher() {
        String dispatches = this.m_initParams.get(WebContainerConstants.FILTER_MAPPING_DISPATCHER);
        if (dispatches != null && dispatches.trim().length() > 0) {
            if (dispatches.indexOf(",") > -1) {
                StringTokenizer tok = new StringTokenizer(dispatches.trim(), ",");
                while (tok.hasMoreTokens()) {
                    String element = tok.nextToken();
                    if (element == null || element.trim().length() <= 0) continue;
                    if (VALID_DISPATCHER_VALUES.contains(element.trim().toLowerCase())) {
                        this.m_dispatcher.add(element.trim());
                        continue;
                    }
                    throw new IllegalArgumentException("Incorrect value of dispatcher " + element.trim());
                }
            } else if (VALID_DISPATCHER_VALUES.contains(dispatches.trim().toLowerCase())) {
                this.m_dispatcher.add(dispatches.trim());
            } else {
                throw new IllegalArgumentException("Incorrect value of dispatcher " + dispatches.trim());
            }
        }
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public String getName() {
        return this.m_name;
    }

    public String[] getUrlPatterns() {
        return this.m_urlPatterns;
    }

    public String[] getServletNames() {
        return this.m_servletNames;
    }

    public Map<String, String> getInitParams() {
        return this.m_initParams;
    }

    public String[] getDispatcher() {
        return this.m_dispatcher.toArray(new String[this.m_dispatcher.size()]);
    }

    private static Map<String, String> convertToMap(Dictionary dictionary) {
        HashMap<String, String> converted = new HashMap<String, String>();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            try {
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = (String)dictionary.get(key);
                    converted.put(key, value);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid init params for the servlet. The key and value must be Strings.");
            }
        }
        return converted;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",urlPatterns=" + Arrays.toString(this.m_urlPatterns) + ",servletNames=" + Arrays.toString(this.m_servletNames) + ",filter=" + this.m_filter + ",context=" + this.getContextModel() + "}";
    }
}

