/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD06;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD06;

public class WebSocketConnectionD06
extends AbstractConnection
implements WebSocketConnection {
    private static final byte[] MAGIC;
    private static final byte[] NORMAL_CLOSE;
    private final IdleCheck _idle;
    private final WebSocketParser _parser;
    private final WebSocketGenerator _generator;
    private final WebSocket _websocket;
    private boolean _closedIn;
    private boolean _closedOut;
    private final WebSocketParser.FrameHandler _frameHandler = new WebSocketParser.FrameHandler(){
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
        private byte _opcode = (byte)-1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrame(boolean more, byte flags, byte opcode, Buffer buffer) {
            WebSocketConnectionD06 webSocketConnectionD06 = WebSocketConnectionD06.this;
            synchronized (webSocketConnectionD06) {
                if (WebSocketConnectionD06.this._closedIn) {
                    return;
                }
                try {
                    byte[] array = buffer.array();
                    switch (opcode) {
                        case 0: {
                            if (this._opcode == 4) {
                                this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length());
                                if (!more) {
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    this._opcode = (byte)-1;
                                    WebSocketConnectionD06.this._websocket.onMessage((byte)4, msg);
                                }
                                break;
                            }
                            if (!more) {
                                this._opcode = (byte)-1;
                            }
                            WebSocketConnectionD06.this._websocket.onFragment(more, this._opcode, array, buffer.getIndex(), buffer.length());
                            break;
                        }
                        case 4: {
                            if (more) {
                                this._opcode = (byte)4;
                                this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length());
                                break;
                            }
                            WebSocketConnectionD06.this._websocket.onMessage(opcode, buffer.toString("UTF-8"));
                            break;
                        }
                        case 2: {
                            Log.debug("PING {}", this);
                            if (!WebSocketConnectionD06.this._closedOut) {
                                WebSocketConnectionD06.this.getOutbound().sendMessage((byte)3, buffer.array(), buffer.getIndex(), buffer.length());
                            }
                            break;
                        }
                        case 3: {
                            Log.debug("PONG {}", this);
                            break;
                        }
                        case 1: {
                            int code = -1;
                            String message = null;
                            if (buffer.length() >= 2) {
                                code = buffer.array()[buffer.getIndex()] * 255 + buffer.array()[buffer.getIndex() + 1];
                                if (buffer.length() > 2) {
                                    message = new String(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, "UTF-8");
                                }
                            }
                            WebSocketConnectionD06.this.closeIn(code, message);
                            break;
                        }
                        default: {
                            if (more) {
                                this._opcode = opcode;
                                WebSocketConnectionD06.this._websocket.onFragment(more, opcode, array, buffer.getIndex(), buffer.length());
                                break;
                            }
                            WebSocketConnectionD06.this._websocket.onMessage(opcode, array, buffer.getIndex(), buffer.length());
                            break;
                        }
                    }
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn(th);
                }
            }
        }

        public String toString() {
            return WebSocketConnectionD06.this.toString() + "FH";
        }
    };
    private final WebSocket.Outbound _outbound = new WebSocket.Outbound(){
        volatile boolean _disconnecting;

        public void sendMessage(String content) throws IOException {
            this.sendMessage((byte)4, content);
        }

        public synchronized void sendMessage(byte opcode, String content) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFrame(opcode, content, WebSocketConnectionD06.this._endp.getMaxIdleTime());
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        public synchronized void sendMessage(byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFrame(opcode, content, offset, length, WebSocketConnectionD06.this._endp.getMaxIdleTime());
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        public void sendFragment(boolean more, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFragment(!more, opcode, content, offset, length, WebSocketConnectionD06.this._endp.getMaxIdleTime());
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        public boolean isOpen() {
            return WebSocketConnectionD06.this._endp != null && WebSocketConnectionD06.this._endp.isOpen();
        }

        public void disconnect(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD06.this.closeOut(code, message);
        }

        public void disconnect() {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD06.this.closeOut(1000, null);
        }
    };

    public WebSocketConnectionD06(WebSocket websocket, EndPoint endpoint, int draft) throws IOException {
        this(websocket, endpoint, new WebSocketBuffers(8192), System.currentTimeMillis(), 300000, draft);
    }

    public WebSocketConnectionD06(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, int draft) throws IOException {
        super(endpoint, timestamp);
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._endp.setMaxIdleTime(maxIdleTime);
        this._websocket = websocket;
        this._generator = new WebSocketGeneratorD06(buffers, this._endp, null);
        this._parser = new WebSocketParserD06(buffers, endpoint, this._frameHandler, true);
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                }
            };
        }
    }

    public WebSocket.Outbound getOutbound() {
        return this._outbound;
    }

    public Connection handle() throws IOException {
        try {
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                Log.ignore(e2);
            }
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._idle.access(this._endp);
                if (this._closedIn && this._closedOut && this._generator.isBufferEmpty()) {
                    this._endp.close();
                } else {
                    this.checkWriteable();
                }
            }
        }
        return this;
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public void idleExpired() {
        this.closeOut(1000, "Idle");
    }

    public boolean isSuspended() {
        return false;
    }

    public void closed() {
        this._websocket.onDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeIn(int code, String message) {
        Log.debug("ClosedIn {} {}", this, message);
        try {
            if (this._closedOut) {
                this._endp.close();
            } else {
                this.closeOut(code, message);
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        finally {
            this._closedIn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeOut(int code, String message) {
        Log.debug("ClosedOut {} {}", this, message);
        try {
            if (this._closedIn || this._closedOut) {
                this._endp.close();
            } else if (code <= 0) {
                this._generator.addFrame((byte)1, NORMAL_CLOSE, 0, 2, this._endp.getMaxIdleTime());
            } else {
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 255);
                bytes[1] = (byte)(code % 255);
                this._generator.addFrame((byte)1, bytes, 0, bytes.length, this._endp.getMaxIdleTime());
            }
            this._generator.flush();
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        finally {
            this._closedOut = true;
        }
    }

    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    public void handshake(HttpServletRequest request, HttpServletResponse response, String origin, String subprotocol) throws IOException {
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && query.length() > 0) {
            uri = uri + "?" + query;
        }
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketConnectionD06.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        response.sendError(101);
        this._websocket.onConnect(this._outbound);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode(md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        NORMAL_CLOSE = new byte[]{3, -21};
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }
}

