/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletEventDispatcher
implements ServletListener {
    private static final Logger LOG = LoggerFactory.getLogger(ServletEventDispatcher.class);
    private final ScheduledExecutorService executors;
    private EventAdmin eventAdminService;
    private LogService logService;
    private final ServiceTracker servletListenerTracker;
    private final Set<ServletListener> listeners = new CopyOnWriteArraySet<ServletListener>();
    private final Map<Bundle, Map<String, ServletEvent>> states = new ConcurrentHashMap<Bundle, Map<String, ServletEvent>>();

    public ServletEventDispatcher(final BundleContext bundleContext, ScheduledExecutorService executors) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle Context");
        NullArgumentException.validateNotNull(executors, "Thread executors");
        this.executors = executors;
        this.servletListenerTracker = new ServiceTracker(bundleContext, ServletListener.class.getName(), new ServiceTrackerCustomizer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference reference) {
                ServletListener listener = (ServletListener)bundleContext.getService(reference);
                Set set = ServletEventDispatcher.this.listeners;
                synchronized (set) {
                    ServletEventDispatcher.this.sendInitialEvents(listener);
                    ServletEventDispatcher.this.listeners.add(listener);
                }
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                ServletEventDispatcher.this.listeners.remove(service);
                bundleContext.ungetService(reference);
            }
        });
        this.servletListenerTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servletEvent(final ServletEvent event) {
        String topic;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending web event " + event + " for bundle " + event.getBundle().getSymbolicName());
        }
        Set<ServletListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(event);
            Map<String, ServletEvent> events = this.states.get(event.getBundle());
            if (events == null) {
                events = new LinkedHashMap<String, ServletEvent>();
                this.states.put(event.getBundle(), events);
            }
            events.put(event.getAlias(), event);
        }
        switch (event.getType()) {
            case 1: {
                topic = WebEvent.WebTopic.DEPLOYING.toString();
                break;
            }
            case 2: {
                topic = WebEvent.WebTopic.DEPLOYED.toString();
                break;
            }
            case 3: {
                topic = WebEvent.WebTopic.UNDEPLOYING.toString();
                break;
            }
            case 4: {
                topic = WebEvent.WebTopic.UNDEPLOYED.toString();
                break;
            }
            case 5: {
                topic = WebEvent.WebTopic.FAILED.toString();
                break;
            }
            case 6: {
                topic = WebEvent.WebTopic.FAILED.toString();
                break;
            }
            default: {
                topic = WebEvent.WebTopic.FAILED.toString();
            }
        }
        if (this.eventAdminService != null) {
            try {
                this.executors.submit(new Runnable(){

                    public void run() {
                        Hashtable<String, Object> properties = new Hashtable<String, Object>();
                        ((Dictionary)properties).put("servlet.alias", event.getAlias() == null ? "" : event.getAlias());
                        ((Dictionary)properties).put("servlet.name", event.getServletName() == null ? "" : event.getServletName());
                        ((Dictionary)properties).put("servlet.urlparameter", event.getUrlParameter() == null ? "" : event.getUrlParameter());
                        ((Dictionary)properties).put("servlet.servlet", event.getServlet());
                        ((Dictionary)properties).put("timestamp", event.getTimestamp());
                        Event event2 = new Event(topic, properties);
                        EventAdmin adminService = ServletEventDispatcher.this.getEventAdminService();
                        if (adminService != null) {
                            adminService.postEvent(event2);
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOG.debug("Executor shut down", (Throwable)ree);
            }
        }
        if (this.logService != null) {
            try {
                this.executors.submit(new Runnable(){

                    public void run() {
                        ServletEventDispatcher.this.getLogService().log(4, topic);
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                LOG.debug("Executor shut down", (Throwable)ree);
            }
        } else {
            LOG.debug(topic);
        }
    }

    void destroy() {
        this.executors.shutdown();
        try {
            this.executors.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.servletListenerTracker.close();
        this.eventAdminService = null;
    }

    private void sendInitialEvents(ServletListener listener) {
        for (Map.Entry<Bundle, Map<String, ServletEvent>> entry : this.states.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                for (ServletEvent event : entry.getValue().values()) {
                    this.callListener(listener, new ServletEvent(event, true));
                }
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListeners(ServletEvent servletEvent) {
        for (ServletListener listener : this.listeners) {
            try {
                this.callListener(listener, servletEvent);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(final ServletListener listener, final ServletEvent event) throws RejectedExecutionException {
        try {
            this.executors.invokeAny(Collections.singleton(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    listener.servletEvent(event);
                    return null;
                }
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOG.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOG.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }

    public void setLogService(Object logService) {
        if (logService instanceof LogService) {
            this.logService = (LogService)logService;
        }
    }

    public void setEventAdminService(Object eventService) {
        if (eventService instanceof EventAdmin) {
            this.eventAdminService = (EventAdmin)eventService;
        }
    }

    private EventAdmin getEventAdminService() {
        return this.eventAdminService;
    }

    private LogService getLogService() {
        return this.logService;
    }
}

