/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.web.service.jetty.internal.HttpServiceContext;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerWrapper;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerImpl
implements JettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerImpl.class);
    private final JettyServerWrapper server;

    JettyServerImpl(ServerModel serverModel) {
        this.server = new JettyServerWrapper(serverModel);
        this.server.setThreadPool(new QueuedThreadPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        LOG.debug("Starting " + this);
        try {
            File serverConfigurationFile;
            URL jettyResource = this.getServerConfigURL();
            if (jettyResource == null) {
                jettyResource = this.getClass().getResource("/jetty.xml");
            }
            if ((serverConfigurationFile = this.getServerConfigDir()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("server configuration file location: " + serverConfigurationFile);
                }
                if (!serverConfigurationFile.isDirectory() && serverConfigurationFile.canRead()) {
                    String fileName;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("server configuration file exists and is readable");
                    }
                    if ((fileName = serverConfigurationFile.getName()).equalsIgnoreCase("jetty.xml")) {
                        jettyResource = serverConfigurationFile.toURI().toURL();
                    }
                } else {
                    LOG.warn("server configuration file location is invalid");
                }
            }
            if (jettyResource != null) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    LOG.debug("Configure using resource " + jettyResource);
                    XmlConfiguration configuration = new XmlConfiguration(jettyResource);
                    Method method = XmlConfiguration.class.getMethod("configure", Object.class);
                    method.invoke((Object)configuration, this.server);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(loader);
                }
            }
            this.server.start();
            Connector[] connectors = this.server.getConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    LOG.info("Pax Web available at [{}]:[{}]", (Object)(connector.getHost() == null ? "0.0.0.0" : connector.getHost()), (Object)connector.getPort());
                }
            } else {
                LOG.info("Pax Web is started with it's default configuration most likely it's listening on port 8181");
            }
        }
        catch (Exception e) {
            LOG.error("Exception while starting Jetty:", (Throwable)e);
            throw new RuntimeException("Exception while starting Jetty", e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("Stopping " + this);
        try {
            this.server.stop();
            this.server.destroy();
        }
        catch (Exception e) {
            LOG.error("Exception while stopping Jetty:", (Throwable)e);
        }
    }

    @Override
    public void addConnector(Connector connector) {
        LOG.info("Pax Web available at [{}]:[{}]", (Object)(connector.getHost() == null ? "0.0.0.0" : connector.getHost()), (Object)connector.getPort());
        this.server.addConnector(connector);
    }

    @Override
    public Connector[] getConnectors() {
        return this.server.getConnectors();
    }

    @Override
    public void removeConnector(Connector connector) {
        LOG.info("Removing connection for [{}]:[{}]", (Object)(connector.getHost() == null ? "0.0.0.0" : connector.getHost()), (Object)connector.getPort());
        this.server.removeConnector(connector);
    }

    @Override
    public void configureContext(Map<String, Object> attributes, Integer sessionTimeout, String sessionCookie, String sessionUrl, Boolean sessionCookieHttpOnly, String workerName, Boolean lazyLoad, String storeDirectory) {
        this.server.configureContext(attributes, sessionTimeout, sessionCookie, sessionUrl, sessionCookieHttpOnly, workerName, lazyLoad, storeDirectory);
    }

    @Override
    public LifeCycle getContext(ContextModel model) {
        final HttpServiceContext context = this.server.getOrCreateContext(model);
        return new LifeCycle(){

            @Override
            public void start() throws Exception {
                context.start();
            }

            @Override
            public void stop() throws Exception {
                context.stop();
            }
        };
    }

    @Override
    public void addServlet(ServletModel model) {
        LOG.debug("Adding servlet [" + model + "]");
        final ServletMapping mapping = new ServletMapping();
        mapping.setServletName(model.getName());
        mapping.setPathSpecs(model.getUrlPatterns());
        HttpServiceContext context = this.server.getOrCreateContext(model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final ServletHolder holder = model.getServlet() == null ? new ServletHolder(model.getServletClass()) : new ServletHolder(model.getServlet());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        if (model.getAsyncSupported() != null) {
            holder.setAsyncSupported(model.getAsyncSupported());
        }
        if (model.getLoadOnStartup() != null) {
            holder.setInitOrder(model.getLoadOnStartup());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addServlet(holder);
                    servletHandler.addServletMapping(mapping);
                    return null;
                }
            });
            if (holder.isStarted()) {
                holder.getServlet();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during servlet registration", (Throwable)e);
        }
    }

    @Override
    public void removeServlet(ServletModel model) {
        ServletHolder holder;
        LOG.debug("Removing servlet [" + model + "]");
        boolean removed = false;
        HttpServiceContext context = this.server.getContext(model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ServletHandler servletHandler = context.getServletHandler();
        ServletHolder[] holders = servletHandler.getServlets();
        if (holders != null && (holder = servletHandler.getServlet(model.getName())) != null) {
            servletHandler.setServlets(LazyList.removeFromArray(holders, holder));
            ServletMapping[] mappings = servletHandler.getServletMappings();
            if (mappings != null) {
                ServletMapping mapping = null;
                for (ServletMapping item : mappings) {
                    if (!holder.getName().equals(item.getServletName())) continue;
                    mapping = item;
                    break;
                }
                if (mapping != null) {
                    servletHandler.setServletMappings(LazyList.removeFromArray(mappings, mapping));
                    removed = true;
                }
            }
            if (holder.isStarted()) {
                try {
                    ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            holder.stop();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    LOG.warn("Exception during unregistering of servlet [" + model + "]");
                }
            }
        }
        if (servletHandler.getServlets() == null || servletHandler.getServlets().length == 0) {
            this.removeContext(model.getContextModel().getHttpContext());
        }
        if (!removed) {
            throw new IllegalStateException(model + " was not found");
        }
    }

    @Override
    public void addEventListener(EventListenerModel model) {
        this.server.getOrCreateContext(model).addEventListener(model.getEventListener());
    }

    @Override
    public void removeEventListener(EventListenerModel model) {
        HttpServiceContext context = this.server.getContext(model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>(Arrays.asList(context.getEventListeners()));
        listeners.remove(model.getEventListener());
        ((ContextHandler)context).setEventListeners(listeners.toArray(new EventListener[listeners.size()]));
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        this.server.removeContext(httpContext);
    }

    @Override
    public void addFilter(FilterModel model) {
        LOG.debug("Adding filter model [" + model + "]");
        final FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(model.getName());
        if (model.getUrlPatterns() != null && model.getUrlPatterns().length > 0) {
            mapping.setPathSpecs(model.getUrlPatterns());
        }
        if (model.getServletNames() != null && model.getServletNames().length > 0) {
            mapping.setServletNames(model.getServletNames());
        }
        int dispatcher = 0;
        for (String d : model.getDispatcher()) {
            dispatcher |= FilterMapping.dispatch(d).ordinal();
        }
        mapping.setDispatches(dispatcher);
        HttpServiceContext context = this.server.getOrCreateContext(model);
        final ServletHandler servletHandler = context.getServletHandler();
        if (servletHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the servlet holder");
        }
        final FilterHolder holder = new FilterHolder(model.getFilter());
        holder.setName(model.getName());
        if (model.getInitParams() != null) {
            holder.setInitParameters(model.getInitParams());
        }
        try {
            ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                @Override
                public Void call() {
                    servletHandler.addFilter(holder, mapping);
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            LOG.error("Ignored exception during filter registration", (Throwable)e);
        }
    }

    @Override
    public void removeFilter(FilterModel model) {
        LOG.debug("Removing filter model [" + model + "]");
        HttpServiceContext context = this.server.getContext(model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ServletHandler servletHandler = context.getServletHandler();
        FilterMapping[] filterMappings = servletHandler.getFilterMappings();
        FilterMapping[] newFilterMappings = null;
        for (FilterMapping filterMapping : filterMappings) {
            if (!filterMapping.getFilterName().equals(model.getName())) continue;
            if (newFilterMappings == null) {
                newFilterMappings = filterMappings;
            }
            newFilterMappings = LazyList.removeFromArray(newFilterMappings, filterMapping);
        }
        servletHandler.setFilterMappings(newFilterMappings);
        final FilterHolder filterHolder = servletHandler.getFilter(model.getName());
        FilterHolder[] filterHolders = servletHandler.getFilters();
        FilterHolder[] newFilterHolders = LazyList.removeFromArray(filterHolders, filterHolder);
        servletHandler.setFilters(newFilterHolders);
        if (filterHolder.isStarted()) {
            try {
                ContextClassLoaderUtils.doWithClassLoader(context.getClassLoader(), new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        filterHolder.stop();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                LOG.warn("Exception during unregistering of filter [" + filterHolder.getFilter() + "]");
            }
        }
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        HttpServiceContext context = this.server.getOrCreateContext(model);
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        try {
            int code = Integer.parseInt(model.getError());
            errorPageHandler.addErrorPage(code, model.getLocation());
        }
        catch (NumberFormatException nfe) {
            errorPageHandler.addErrorPage(model.getError(), model.getLocation());
        }
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        HttpServiceContext context = this.server.getContext(model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        ErrorPageErrorHandler errorPageHandler = (ErrorPageErrorHandler)context.getErrorHandler();
        if (errorPageHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the error handler. Please report.");
        }
        Map<String, String> errorPages = errorPageHandler.getErrorPages();
        if (errorPages != null) {
            errorPages.remove(model.getError());
        }
    }

    @Override
    public void addSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        HttpServiceContext context = this.server.getOrCreateContext(model);
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        String mappingMethod = model.getMapping();
        String constraintName = model.getConstraintName();
        String url = model.getUrl();
        String dataConstraint = model.getDataConstraint();
        List<String> roles = model.getRoles();
        boolean authentication = model.isAuthentication();
        ConstraintMapping newConstraintMapping = new ConstraintMapping();
        newConstraintMapping.setMethod(mappingMethod);
        newConstraintMapping.setPathSpec(url);
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(authentication);
        constraint.setName(constraintName);
        constraint.setRoles(roles.toArray(new String[roles.size()]));
        if (dataConstraint == null || "NONE".equals(dataConstraint)) {
            constraint.setDataConstraint(0);
        } else if ("INTEGRAL".equals(dataConstraint)) {
            constraint.setDataConstraint(1);
        } else if ("CONFIDENTIAL".equals(dataConstraint)) {
            constraint.setDataConstraint(2);
        } else {
            LOG.warn("Unknown user-data-constraint:" + dataConstraint);
            constraint.setDataConstraint(2);
        }
        newConstraintMapping.setConstraint(constraint);
        ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(newConstraintMapping);
    }

    @Override
    public void addServletContainerInitializer(ContainerInitializerModel model) {
    }

    @Override
    public void removeSecurityConstraintMappings(SecurityConstraintMappingModel model) {
        HttpServiceContext context = this.server.getContext(model.getContextModel().getHttpContext());
        if (context == null) {
            return;
        }
        SecurityHandler securityHandler = context.getSecurityHandler();
        if (securityHandler == null) {
            throw new IllegalStateException("Internal error: Cannot find the security handler. Please report.");
        }
        List<ConstraintMapping> constraintMappings = ((ConstraintSecurityHandler)securityHandler).getConstraintMappings();
        for (ConstraintMapping constraintMapping : constraintMappings) {
            boolean urlMatch = constraintMapping.getPathSpec().equalsIgnoreCase(model.getUrl());
            boolean methodMatch = constraintMapping.getMethod().equalsIgnoreCase(model.getMapping());
            if (!urlMatch || !methodMatch) continue;
            constraintMappings.remove(constraintMapping);
        }
    }

    @Override
    public void configureRequestLog(String format, String retainDays, Boolean append, Boolean extend, Boolean dispatch, String timeZone, String directory) {
        File file;
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        if (directory == null || directory.isEmpty()) {
            directory = "./logs/";
        }
        if (!(file = new File(directory)).exists()) {
            file.mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOG.error("can't create NCSARequestLog", (Throwable)e);
            }
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        NCSARequestLog requestLog = new NCSARequestLog(directory + format);
        requestLog.setRetainDays(Integer.parseInt(retainDays));
        requestLog.setAppend(append);
        requestLog.setExtended(extend);
        requestLog.setLogDispatch(dispatch);
        requestLog.setLogTimeZone(timeZone);
        requestLogHandler.setRequestLog(requestLog);
        ((HandlerCollection)this.server.getHandler()).addHandler(requestLogHandler);
    }

    public String toString() {
        return JettyServerImpl.class.getSimpleName() + "{" + "}";
    }

    @Override
    public void setServerConfigDir(File serverConfigDir) {
        this.server.setServerConfigDir(serverConfigDir);
    }

    @Override
    public File getServerConfigDir() {
        return this.server.getServerConfigDir();
    }

    @Override
    public void setServerConfigURL(URL serverConfigURL) {
        this.server.setServerConfigURL(serverConfigURL);
    }

    @Override
    public URL getServerConfigURL() {
        return this.server.getServerConfigURL();
    }

    JettyServerWrapper getServer() {
        return this.server;
    }
}

