/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal.util;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.web.service.jetty.internal.util.Loader;
import org.ops4j.pax.web.service.jetty.internal.util.TypeUtil;
import org.ops4j.util.xml.ElementHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DOMJettyWebXmlParser {
    private static final Logger LOG = LoggerFactory.getLogger(DOMJettyWebXmlParser.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Integer ZERO = new Integer(0);
    Map<String, Object> _idMap;
    Map<String, String> _propertyMap;

    public Object parse(Object webApp, InputStream inputStream) {
        try {
            Element rootElement = ElementHelper.getRootElement(inputStream);
            this.configure(webApp, rootElement, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void configure(Object obj, Element cfg, int startIdx) throws Exception {
        String id = ElementHelper.getAttribute(cfg, "id");
        if (id != null) {
            this._idMap.put(id, obj);
        }
        Element[] children = ElementHelper.getChildren(cfg);
        for (int i = startIdx; i < children.length; ++i) {
            Element node = children[i];
            try {
                String tag = node.getTagName();
                if ("Set".equals(tag)) {
                    this.set(obj, node);
                    continue;
                }
                if ("Put".equals(tag)) {
                    this.put(obj, node);
                    continue;
                }
                if ("Call".equals(tag)) {
                    this.call(obj, node);
                    continue;
                }
                if ("Get".equals(tag)) {
                    this.get(obj, node);
                    continue;
                }
                if ("New".equals(tag)) {
                    this.newObj(obj, node);
                    continue;
                }
                if ("Array".equals(tag)) {
                    this.newArray(obj, node);
                    continue;
                }
                if ("Ref".equals(tag)) {
                    this.refObj(obj, node);
                    continue;
                }
                if ("Property".equals(tag)) {
                    this.propertyObj(obj, node);
                    continue;
                }
                throw new IllegalStateException("Unknown tag: " + tag);
            }
            catch (Exception e) {
                LOG.warn("Config error at " + node, (Object)e.toString());
                throw e;
            }
        }
    }

    private Class<?> nodeClass(Element node) throws ClassNotFoundException {
        String className = ElementHelper.getAttribute(node, "class");
        if (className == null) {
            return null;
        }
        return Loader.loadClass(DOMJettyWebXmlParser.class, className, true);
    }

    private void set(Object obj, Element node) throws Exception {
        Class[] vClass;
        Class<?> oClass;
        String name;
        block44: {
            Object[] arg;
            Object value;
            block42: {
                String attr;
                block41: {
                    block40: {
                        attr = ElementHelper.getAttribute(node, "name");
                        name = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
                        value = this.value(obj, node);
                        arg = new Object[]{value};
                        oClass = this.nodeClass(node);
                        if (oClass != null) {
                            obj = null;
                        } else {
                            oClass = obj.getClass();
                        }
                        vClass = new Class[]{Object.class};
                        if (value != null) {
                            vClass[0] = value.getClass();
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("XML " + (obj != null ? obj.toString() : oClass.getName()) + "." + name + "(" + value + ")");
                        }
                        try {
                            Method set = oClass.getMethod(name, vClass);
                            set.invoke(obj, arg);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("IllegalArgument while parsing jetty-web.xml", (Throwable)e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            if (!LOG.isInfoEnabled()) break block40;
                            LOG.info("NoSuchMethodException while parsing jetty-web.xml", (Throwable)e);
                        }
                    }
                    try {
                        Field type = vClass[0].getField("TYPE");
                        vClass[0] = (Class)type.get(null);
                        Method set = oClass.getMethod(name, vClass);
                        set.invoke(obj, arg);
                        return;
                    }
                    catch (NoSuchFieldException e) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("NoSuchFieldException while parsing jetty-web.xml", (Throwable)e);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IllegalArgumentException while parsing jetty-web.xml", (Throwable)e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        if (!LOG.isInfoEnabled()) break block41;
                        LOG.info("NoSuchMethodException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                try {
                    Field field = oClass.getField(attr);
                    if (Modifier.isPublic(field.getModifiers())) {
                        field.set(obj, value);
                        return;
                    }
                }
                catch (NoSuchFieldException e) {
                    if (!LOG.isInfoEnabled()) break block42;
                    LOG.info("NoSuchFieldException while parsing jetty-web.xml", (Throwable)e);
                }
            }
            Method[] sets = oClass.getMethods();
            Method set = null;
            for (int s = 0; sets != null && s < sets.length; ++s) {
                Class<?>[] paramTypes;
                block43: {
                    paramTypes = sets[s].getParameterTypes();
                    if (!name.equals(sets[s].getName()) || paramTypes.length != 1) continue;
                    try {
                        set = sets[s];
                        sets[s].invoke(obj, arg);
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("IllegalArgumentException while parsing jetty-web.xml", (Throwable)e);
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (!LOG.isInfoEnabled()) break block43;
                        LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                if (!paramTypes[0].isAssignableFrom(Collection.class) || !value.getClass().isArray()) continue;
                try {
                    if (paramTypes[0].isAssignableFrom(Set.class)) {
                        sets[s].invoke(obj, new HashSet<Object>(Arrays.asList((Object[])value)));
                    } else {
                        sets[s].invoke(obj, Arrays.asList((Object[])value));
                    }
                    return;
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("IllegalArgumentException while parsing jetty-web.xml", (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                }
            }
            if (set != null) {
                try {
                    Class<?> sClass = set.getParameterTypes()[0];
                    if (sClass.isPrimitive()) {
                        for (int t = 0; t < __primitives.length; ++t) {
                            if (!sClass.equals(__primitives[t])) continue;
                            sClass = __primitiveHolders[t];
                            break;
                        }
                    }
                    Constructor<?> cons = sClass.getConstructor(vClass);
                    arg[0] = cons.newInstance(arg);
                    set.invoke(obj, arg);
                    return;
                }
                catch (NoSuchMethodException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("NoSuchMethodException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    if (!LOG.isInfoEnabled()) break block44;
                    LOG.info("InstantiationException while parsing jetty-web.xml", (Throwable)e);
                }
            }
        }
        throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
    }

    private void put(Object obj, Element node) throws Exception {
        if (!(obj instanceof Map)) {
            throw new IllegalArgumentException("Object for put is not a Map: " + obj);
        }
        Map map = (Map)obj;
        String name = ElementHelper.getAttribute(node, "name");
        Object value = this.value(obj, node);
        map.put(name, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML " + obj + ".put(" + name + "," + value + ")");
        }
    }

    private Object get(Object obj, Element node) throws Exception {
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else {
            oClass = obj.getClass();
        }
        String name = ElementHelper.getAttribute(node, "name");
        String id = ElementHelper.getAttribute(node, "id");
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML get " + name);
        }
        try {
            Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), null);
            obj = method.invoke(obj, (Object[])null);
            this.configure(obj, node, 0);
        }
        catch (NoSuchMethodException nsme) {
            try {
                Field field = oClass.getField(name);
                obj = field.get(obj);
                this.configure(obj, node, 0);
            }
            catch (NoSuchFieldException nsfe) {
                throw nsme;
            }
        }
        if (id != null) {
            this._idMap.put(id, obj);
        }
        return obj;
    }

    private Object call(Object obj, Element node) throws Exception {
        String id = ElementHelper.getAttribute(node, "id");
        Class<?> oClass = this.nodeClass(node);
        if (oClass != null) {
            obj = null;
        } else if (obj != null) {
            oClass = obj.getClass();
        }
        if (oClass == null) {
            throw new IllegalArgumentException(node.toString());
        }
        int size = 0;
        Element[] children = ElementHelper.getChildren(node);
        int argi = children.length;
        for (int i = 0; i < children.length; ++i) {
            Element element = children[i];
            if (!element.getTagName().equals("Arg")) {
                argi = i;
                break;
            }
            ++size;
        }
        Object[] arg = new Object[size];
        int i = 0;
        int j = 0;
        while (j < size) {
            Element element = children[i];
            arg[j++] = this.value(obj, element);
            ++i;
        }
        String method = ElementHelper.getAttribute(node, "name");
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML call " + method);
        }
        try {
            Object n = TypeUtil.call(oClass, method, obj, arg);
            if (id != null) {
                this._idMap.put(id, n);
            }
            this.configure(n, node, argi);
            return n;
        }
        catch (NoSuchMethodException e) {
            IllegalStateException ise = new IllegalStateException("No Method: " + node + " on " + oClass);
            ise.initCause(e);
            throw ise;
        }
    }

    private Object newObj(Object obj, Element node) throws Exception {
        Class<?> oClass = this.nodeClass(node);
        String id = ElementHelper.getAttribute(node, "id");
        int size = 0;
        Element[] children = ElementHelper.getChildren(node);
        int argi = children.length;
        for (int i = 0; i < children.length; ++i) {
            Element element = children[i];
            if (!element.getTagName().equals("Arg")) {
                argi = i;
                break;
            }
            ++size;
        }
        Object[] arg = new Object[size];
        int i = 0;
        int j = 0;
        while (j < size) {
            Element o = children[i];
            arg[j++] = this.value(obj, o);
            ++i;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML new " + oClass);
        }
        Constructor<?>[] constructors = oClass.getConstructors();
        for (int c = 0; constructors != null && c < constructors.length; ++c) {
            boolean called;
            Object n;
            block12: {
                if (constructors[c].getParameterTypes().length != size) continue;
                n = null;
                called = false;
                try {
                    n = constructors[c].newInstance(arg);
                    called = true;
                }
                catch (IllegalAccessException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("IllegalAccessException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("InstantiationException while parsing jetty-web.xml", (Throwable)e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isInfoEnabled()) break block12;
                    LOG.info("IllegalArgumentException while parsing jetty-web.xml", (Throwable)e);
                }
            }
            if (!called) continue;
            if (id != null) {
                this._idMap.put(id, n);
            }
            this.configure(n, node, argi);
            return n;
        }
        throw new IllegalStateException("No Constructor: " + node + " on " + obj);
    }

    private Object refObj(Object obj, Element node) throws Exception {
        String id = ElementHelper.getAttribute(node, "id");
        obj = this._idMap.get(id);
        if (obj == null) {
            throw new IllegalStateException("No object for id=" + id);
        }
        this.configure(obj, node, 0);
        return obj;
    }

    private Object newArray(Object obj, Element node) throws Exception {
        Element[] children;
        Class aClass = Object.class;
        String type = ElementHelper.getAttribute(node, "type");
        String id = ElementHelper.getAttribute(node, "id");
        if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
            aClass = "String".equals(type) ? String.class : ("URL".equals(type) ? URL.class : ("InetAddress".equals(type) ? InetAddress.class : Loader.loadClass(DOMJettyWebXmlParser.class, type, true)));
        }
        ArrayList<Object> al = null;
        for (Element item : children = ElementHelper.getChildren(node, "Item")) {
            String nid = ElementHelper.getAttribute(item, "id");
            Object v = this.value(obj, item);
            if (al == null) {
                al = new ArrayList<Object>();
            }
            al.add(v == null && aClass.isPrimitive() ? ZERO : v);
            if (nid == null) continue;
            this._idMap.put(nid, v);
        }
        Object array = DOMJettyWebXmlParser.toArray(al, aClass);
        if (id != null) {
            this._idMap.put(id, array);
        }
        return array;
    }

    private Object newMap(Object obj, Element node) throws Exception {
        String id = ElementHelper.getAttribute(node, "id");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (id != null) {
            this._idMap.put(id, map);
        }
        Element[] children = ElementHelper.getChildren(node);
        for (int i = 0; i < children.length; ++i) {
            Element element = children[i];
            if (!element.getTagName().equals("Entry")) {
                throw new IllegalStateException("Not an Entry");
            }
            Element key = null;
            Element value = null;
            Element[] entries = ElementHelper.getChildren(element);
            for (int j = 0; j < entries.length; ++j) {
                Element item = entries[j];
                if (!item.getTagName().equals("Item")) {
                    throw new IllegalStateException("Not an Item");
                }
                if (key == null) {
                    key = item;
                    continue;
                }
                value = item;
            }
            if (key == null || value == null) {
                throw new IllegalStateException("Missing Item in Entry");
            }
            String kid = ElementHelper.getAttribute(key, "id");
            String vid = ElementHelper.getAttribute(value, "id");
            Object k = this.value(obj, key);
            Object v = this.value(obj, value);
            map.put(k, v);
            if (kid != null) {
                this._idMap.put(kid, k);
            }
            if (vid == null) continue;
            this._idMap.put(vid, v);
        }
        return map;
    }

    private Object propertyObj(Object obj, Element node) throws Exception {
        String id = ElementHelper.getAttribute(node, "id");
        String name = ElementHelper.getAttribute(node, "name");
        String defval = ElementHelper.getAttribute(node, "default");
        String prop = null;
        prop = this._propertyMap != null && this._propertyMap.containsKey(name) ? this._propertyMap.get(name) : defval;
        if (id != null) {
            this._idMap.put(id, prop);
        }
        if (prop != null) {
            this.configure(prop, node, 0);
        }
        return prop;
    }

    private Object value(Object obj, Element node) throws Exception {
        Object value = null;
        String type = ElementHelper.getAttribute(node, "type");
        String ref = ElementHelper.getAttribute(node, "ref");
        if (ref != null) {
            value = this._idMap.get(ref);
        } else {
            if (ElementHelper.getChildren(node).length == 0 && (ElementHelper.getValue(node) == null || ElementHelper.getValue(node).length() == 0)) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            int last = ElementHelper.getValue(node).length() - 1;
            if (type == null || !"String".equals(type)) {
                int first;
                String item = null;
                for (first = 0; first <= last && (item = ElementHelper.getValue(node)) instanceof String && (item = item.trim()).length() <= 0; ++first) {
                }
                while (first < last && (item = ElementHelper.getValue(node)) instanceof String && (item = item.trim()).length() <= 0) {
                    --last;
                }
                if (first > last) {
                    if (ElementHelper.getChildren(node).length == 0) {
                        return null;
                    }
                    value = this.itemValue(obj, ElementHelper.getChildren(node)[0]);
                } else {
                    value = item;
                }
            }
        }
        if (value == null) {
            if ("String".equals(type)) {
                return "";
            }
            return null;
        }
        if (type == null) {
            if (value != null && value instanceof String) {
                return ((String)value).trim();
            }
            return value;
        }
        if ("String".equals(type) || "java.lang.String".equals(type)) {
            return value.toString();
        }
        Class<?> pClass = TypeUtil.fromName(type);
        if (pClass != null) {
            return TypeUtil.valueOf(pClass, value.toString());
        }
        if ("URL".equals(type) || "java.net.URL".equals(type)) {
            if (value instanceof URL) {
                return value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException e) {
                throw new InvocationTargetException(e);
            }
        }
        if ("InetAddress".equals(type) || "java.net.InetAddress".equals(type)) {
            if (value instanceof InetAddress) {
                return value;
            }
            try {
                return InetAddress.getByName(value.toString());
            }
            catch (UnknownHostException e) {
                throw new InvocationTargetException(e);
            }
        }
        throw new IllegalStateException("Unknown type " + type);
    }

    private Object itemValue(Object obj, Object item) throws Exception {
        if (item instanceof String) {
            return item;
        }
        Element node = (Element)item;
        String tag = node.getTagName();
        if ("Call".equals(tag)) {
            return this.call(obj, node);
        }
        if ("Get".equals(tag)) {
            return this.get(obj, node);
        }
        if ("New".equals(tag)) {
            return this.newObj(obj, node);
        }
        if ("Ref".equals(tag)) {
            return this.refObj(obj, node);
        }
        if ("Array".equals(tag)) {
            return this.newArray(obj, node);
        }
        if ("Map".equals(tag)) {
            return this.newMap(obj, node);
        }
        if ("Property".equals(tag)) {
            return this.propertyObj(obj, node);
        }
        if ("SystemProperty".equals(tag)) {
            String name = ElementHelper.getAttribute(node, "name");
            String defaultValue = ElementHelper.getAttribute(node, "default");
            return System.getProperty(name, defaultValue);
        }
        LOG.warn("Unknown value tag: " + node, new Throwable());
        return null;
    }

    public static Object toArray(Object list, Class<?> clazz) {
        if (list == null) {
            return Array.newInstance(clazz, 0);
        }
        if (list instanceof List) {
            List l = (List)list;
            if (clazz.isPrimitive()) {
                Object a = Array.newInstance(clazz, l.size());
                for (int i = 0; i < l.size(); ++i) {
                    Array.set(a, i, l.get(i));
                }
                return a;
            }
            return l.toArray((Object[])Array.newInstance(clazz, l.size()));
        }
        Object a = Array.newInstance(clazz, 1);
        Array.set(a, 0, list);
        return a;
    }
}

