/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JasperClassLoader
extends URLClassLoader {
    private final BundleClassLoader m_bundleClassLoader;
    private static final Logger LOG = LoggerFactory.getLogger(JasperClassLoader.class);
    private static final String bundleClassLoaderClassName = "org.ops4j.pax.swissbox.core.BundleClassLoader";
    private static final String osgiBundleClassName = "org.osgi.framework.Bundle";

    public JasperClassLoader(Bundle bundle, ClassLoader parent) {
        super(JasperClassLoader.getClassPathJars(bundle));
        this.m_bundleClassLoader = new BundleClassLoader(bundle, parent);
    }

    @Override
    public URL getResource(String name) {
        return this.m_bundleClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.m_bundleClassLoader.getResources(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.m_bundleClassLoader.loadClass(name);
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("bundleClassLoader=").append(this.m_bundleClassLoader).append("}").toString();
    }

    private static URL[] getClassPathJars(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String bundleClasspath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            String[] segments;
            for (String segment : segments = bundleClasspath.split(",")) {
                URL url = bundle.getEntry(segment);
                if (url == null || !url.toExternalForm().endsWith("jar")) continue;
                LOG.debug("Using url: " + url);
                try {
                    URL jarUrl = new URL("jar:" + url.toExternalForm() + "!/");
                    urls.add(jarUrl);
                }
                catch (MalformedURLException ignore) {
                    LOG.debug(ignore.getMessage());
                }
            }
        }
        LOG.debug("Bundle-ClassPath URLs: " + urls);
        urls.addAll(JasperClassLoader.getLocationsOfBundlesInClassSpace(bundle));
        return urls.toArray(new URL[urls.size()]);
    }

    private static List<URL> getLocationsOfBundlesInClassSpace(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        List<Bundle> importedBundles = JasperClassLoader.getBundlesInClassSpace(bundle);
        for (Bundle importedBundle : importedBundles) {
            URL url = JasperClassLoader.getLocationOfBundle(importedBundle);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private static URL getLocationOfBundle(Bundle importedBundle) {
        URL url = null;
        try {
            url = new URL(importedBundle.getLocation());
        }
        catch (MalformedURLException e) {
            try {
                url = importedBundle.getEntry("/");
            }
            catch (Exception e2) {
                LOG.warn("Exception while calculating location of bundle", (Throwable)e);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Bundle> getBundlesInClassSpace(Bundle bundle) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        ServiceReference ref = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            System.out.println("PackageAdmin service is unavailable.");
            return bundles;
        }
        try {
            String name;
            String[] split;
            PackageAdmin pa = (PackageAdmin)bundle.getBundleContext().getService(ref);
            if (pa == null) {
                System.out.println("PackageAdmin service is unavailable.");
                ArrayList<Bundle> arrayList = bundles;
                return arrayList;
            }
            Dictionary headers = bundle.getHeaders();
            String importPackage = (String)headers.get("Import-Package");
            String requiredBundleHeader = (String)headers.get("Require-Bundle");
            if (importPackage != null) {
                String[] importPackages;
                for (String impPackage : importPackages = importPackage.split(",")) {
                    ExportedPackage[] exportedPackages;
                    split = impPackage.split(";");
                    name = split[0].trim();
                    if (name.matches("^[0-9].*") || (exportedPackages = pa.getExportedPackages(name)) == null) continue;
                    for (ExportedPackage exportedPackage : exportedPackages) {
                        Bundle exportingBundle;
                        if (!Arrays.asList(exportedPackage.getImportingBundles()).contains(bundle) || (exportingBundle = exportedPackage.getExportingBundle()).getBundleId() == 0L) continue;
                        bundles.add(exportingBundle);
                    }
                }
            }
            if (requiredBundleHeader != null) {
                String[] reqBundles;
                for (String reqBundle : reqBundles = requiredBundleHeader.split(",")) {
                    RequiredBundle[] requiredBundles;
                    split = reqBundle.split(";");
                    name = split[0].trim();
                    if (name.matches("^[0-9].*") || (requiredBundles = pa.getRequiredBundles(name)) == null) continue;
                    for (ExportedPackage exportedPackage : requiredBundles) {
                        if (!Arrays.asList(exportedPackage.getRequiringBundles()).contains(bundle) || exportedPackage.getBundle().getBundleId() == 0L) continue;
                        bundles.add(exportedPackage.getBundle());
                    }
                }
            }
        }
        finally {
            bundle.getBundleContext().ungetService(ref);
        }
        return bundles;
    }

    public List<URL> scanBundlesInClassSpace(String directory, String filePattern, boolean recursive) {
        List<Bundle> bundlesInClassSpace = JasperClassLoader.getBundlesInClassSpace(this.m_bundleClassLoader.getBundle());
        ArrayList<URL> matching = new ArrayList<URL>();
        for (Bundle bundle : bundlesInClassSpace) {
            Enumeration e = bundle.findEntries(directory, filePattern, recursive);
            if (e == null) continue;
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                matching.add(u);
            }
        }
        return matching;
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    public boolean equals(Object o) {
        LOG.trace("JasperClassLoader.equals() invoked");
        if (this == o) {
            LOG.trace("JasperClassLoader.equals(): same object");
            return true;
        }
        if (o == null) {
            LOG.trace("JasperClassLoader.equals(): testing equality against null object");
            return false;
        }
        if (!o.getClass().getCanonicalName().equals(bundleClassLoaderClassName)) {
            LOG.trace("JasperClassLoader.equals(): testing equality against another JasperClassLoader object");
            return super.equals(o);
        }
        LOG.trace("JasperClassLoader.equals(): testing equality against a BundleClassLoader object");
        long myBundleId = -1L;
        long theirBundleId = -2L;
        try {
            myBundleId = this.m_bundleClassLoader.getBundle().getBundleId();
            Class<?> bundleClassLoaderClass = o.getClass().getClassLoader().loadClass(bundleClassLoaderClassName);
            Object bundle = bundleClassLoaderClass.getMethod("getBundle", new Class[0]).invoke(o, null);
            Class<?> bundleClass = o.getClass().getClassLoader().loadClass(osgiBundleClassName);
            theirBundleId = (Long)bundleClass.getMethod("getBundleId", new Class[0]).invoke(bundle, null);
        }
        catch (Exception e) {
            LOG.error("Unable to evaluate equality of JasperClassLoader object against BundleClassLoader object", (Throwable)e);
        }
        return myBundleId == theirBundleId;
    }

    public int hashCode() {
        LOG.trace("Using m_bundleClassloader.hashCode()");
        Bundle bundle = this.m_bundleClassLoader.getBundle();
        int hash = bundle != null ? bundle.hashCode() * 37 : this.m_bundleClassLoader.hashCode();
        LOG.trace("m_bundleClassloader.hashCode() result: " + hash);
        return hash;
    }
}

