/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private final Object lock = new Object();
    private final LinkedList jobs = new LinkedList();
    private Worker worker;
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future submit(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            Future future = new Future(runnable);
            this.jobs.add(future);
            if (this.worker == null) {
                this.worker = new Worker();
                this.worker.start();
            }
            return future;
        }
    }

    public boolean isWorkerThread() {
        return Thread.currentThread() == this.worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            while (!this.jobs.isEmpty()) {
                this.lock.wait();
            }
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
            super("Pax Web Runtime worker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Future job;
                Object object = Executor.this.lock;
                synchronized (object) {
                    if (Executor.this.jobs.isEmpty()) {
                        Executor.this.worker = null;
                        break;
                    }
                    job = (Future)Executor.this.jobs.getFirst();
                }
                try {
                    job.run();
                }
                catch (Throwable t) {
                    LOG.equals(t);
                }
                object = Executor.this.lock;
                synchronized (object) {
                    Executor.this.jobs.removeFirst();
                    Executor.this.lock.notifyAll();
                }
            }
        }
    }

    public static class Future {
        boolean done;
        Runnable runnable;
        final Object lock = new Object();

        Future(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            try {
                this.runnable.run();
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                if (!this.done) {
                    this.lock.wait();
                }
            }
        }
    }
}

