/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ContextModel
extends Identity {
    private final HttpContext httpContext;
    private final ClassLoader classLoader;
    private final Map<String, String> contextParams;
    private String contextName;
    private Filter welcomeFilesFilter;
    private AccessControlContext accessControllerContext;
    private Map<Servlet, String[]> jspServlets;
    private Integer sessionTimeout;
    private String sessionCookie;
    private String sessionUrl;
    private Boolean sessionCookieHttpOnly;
    private String sessionWorkerName;
    private final Bundle bundle;
    private String realmName;
    private String authMethod;
    private String formLoginPage;
    private String formErrorPage;
    private Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers;
    private URL jettyWebXmlUrl;
    private final List<String> virtualHosts;
    private final List<String> connectors;

    public ContextModel(HttpContext httpContext, Bundle bundle, ClassLoader classLoader) {
        this.bundle = bundle;
        NullArgumentException.validateNotNull(httpContext, "Http context");
        NullArgumentException.validateNotNull(classLoader, "Class loader");
        this.classLoader = classLoader;
        this.httpContext = httpContext;
        this.contextParams = new HashMap<String, String>();
        this.jspServlets = new IdentityHashMap<Servlet, String[]>();
        this.contextName = "";
        this.accessControllerContext = AccessController.getContext();
        this.virtualHosts = new ArrayList<String>();
        this.connectors = new ArrayList<String>();
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public void setContextParams(Dictionary contextParameters) {
        this.contextParams.clear();
        if (contextParameters != null && !contextParameters.isEmpty()) {
            Enumeration keys = contextParameters.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = contextParameters.get(key);
                if (!(key instanceof String) || !(value instanceof String)) {
                    throw new IllegalArgumentException("Context params keys and values must be Strings");
                }
                this.contextParams.put((String)key, (String)value);
            }
            this.contextName = this.contextParams.get("webapp.context");
        }
        this.contextName = this.contextName != null ? this.contextName.trim() : "";
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Map<Servlet, String[]> getJspServlets() {
        return this.jspServlets;
    }

    public AccessControlContext getAccessControllerContext() {
        return this.accessControllerContext;
    }

    public Filter getWelcomeFilesFilter() {
        return this.welcomeFilesFilter;
    }

    public void setWelcomeFilesFilter(Filter welcomeFilesFilter) {
        this.welcomeFilesFilter = welcomeFilesFilter;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public String getSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(String sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public String getSessionUrl() {
        return this.sessionUrl;
    }

    public void setSessionUrl(String sessionUrl) {
        this.sessionUrl = sessionUrl;
    }

    public Boolean getSessionCookieHttpOnly() {
        return this.sessionCookieHttpOnly;
    }

    public void setSessionCookieHttpOnly(Boolean sessionCookieHttpOnly) {
        this.sessionCookieHttpOnly = sessionCookieHttpOnly;
    }

    public String getSessionWorkerName() {
        return this.sessionWorkerName;
    }

    public void setSessionWorkerName(String sessionWorkerName) {
        this.sessionWorkerName = sessionWorkerName;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append("id=").append(this.getId()).append(",name=").append(this.contextName).append(",httpContext=").append(this.httpContext).append(",contextParams=").append(this.contextParams).append(",virtualHosts={");
        for (String virtualHost : this.virtualHosts) {
            sb.append(virtualHost).append(",");
        }
        sb.append("},connectors={");
        for (String connector : this.connectors) {
            sb.append(connector).append(",");
        }
        return sb.append("}}").toString();
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setFormLoginPage(String formLoginPage) {
        this.formLoginPage = formLoginPage;
    }

    public void setFormErrorPage(String formErrorPage) {
        this.formErrorPage = formErrorPage;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Map<ServletContainerInitializer, Set<Class<?>>> getContainerInitializers() {
        return this.containerInitializers;
    }

    public void setContainerInitializers(Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers) {
        this.containerInitializers = containerInitializers;
    }

    public void addContainerInitializer(ServletContainerInitializer containerInitializer, Set<Class<?>> classes) {
        if (this.containerInitializers == null) {
            this.containerInitializers = new HashMap();
        }
        this.containerInitializers.put(containerInitializer, classes);
    }

    public void setVirtualHosts(List<String> virtualHosts) {
        this.virtualHosts.clear();
        this.virtualHosts.addAll(virtualHosts);
    }

    public List<String> getVirtualHosts() {
        return this.virtualHosts;
    }

    public void setConnectors(List<String> connectors) {
        this.connectors.clear();
        this.connectors.addAll(connectors);
    }

    public List<String> getConnectors() {
        return this.connectors;
    }

    public void setJettyWebXmlUrl(URL jettyWebXmlUrl) {
        this.jettyWebXmlUrl = jettyWebXmlUrl;
    }

    public URL getJettyWebXmlURL() {
        return this.jettyWebXmlUrl;
    }
}

