/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.internal.ConfigurationImpl;
import org.ops4j.pax.web.service.internal.DefaultPropertyResolver;
import org.ops4j.pax.web.service.internal.EventAdminHandler;
import org.ops4j.pax.web.service.internal.HttpServiceFactoryImpl;
import org.ops4j.pax.web.service.internal.HttpServiceProxy;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.LogServiceHandler;
import org.ops4j.pax.web.service.internal.ServletEventDispatcher;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerFactory;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.FallbackPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private ServerController serverController;
    private ServiceRegistration<?> httpServiceFactoryReg;
    private BundleContext bundleContext;
    private ServletEventDispatcher servletEventDispatcher;
    private ServiceTracker<EventAdmin, EventAdmin> eventServiceTracker;
    private ServiceTracker<LogService, LogService> logServiceTracker;
    private ServiceTracker<ServerControllerFactory, ServerControllerFactory> dynamicsServiceTracker;
    private final ExecutorService configExecutor = new ThreadPoolExecutor(0, 1, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private Dictionary<String, ?> config;
    private ServerControllerFactory factory;
    private boolean initialConfigSet;

    public void start(BundleContext context) throws Exception {
        LOG.debug("Starting Pax Web");
        this.bundleContext = context;
        this.servletEventDispatcher = new ServletEventDispatcher(context);
        if (SupportUtils.isEventAdminAvailable()) {
            Filter filterEvent = context.createFilter("(objectClass=org.osgi.service.event.EventAdmin)");
            EventAdminHandler adminHandler = new EventAdminHandler(context);
            this.eventServiceTracker = new ServiceTracker(context, filterEvent, (ServiceTrackerCustomizer)adminHandler);
            this.eventServiceTracker.open();
            context.registerService(ServletListener.class, (Object)adminHandler, null);
            LOG.info("EventAdmin support enabled, servlet events will be postet to topics.");
        } else {
            LOG.info("EventAdmin support is not available, no servlet events will be posted!");
        }
        if (SupportUtils.isLogServiceAvailable()) {
            Filter filterLog = context.createFilter("(objectClass=org.osgi.service.log.LogService)");
            LogServiceHandler logServiceHandler = new LogServiceHandler(context);
            this.logServiceTracker = new ServiceTracker(context, filterLog, (ServiceTrackerCustomizer)logServiceHandler);
            this.logServiceTracker.open();
            context.registerService(ServletListener.class, (Object)logServiceHandler, null);
            LOG.info("LogService support enabled, log events will be created.");
        } else {
            LOG.info("LogService support is not available, no log events will be created!");
        }
        if (SupportUtils.isManagedServiceAvailable()) {
            this.createManagedService(context);
        } else {
            this.scheduleUpdateConfig(null);
        }
        if (SupportUtils.isJSPAvailable()) {
            System.setProperty("org.apache.jasper.compiler.disablejsr199", Boolean.TRUE.toString());
        }
        LOG.info("Pax Web started");
    }

    public void stop(BundleContext context) {
        LOG.debug("Stopping Pax Web...");
        if (this.dynamicsServiceTracker != null) {
            this.dynamicsServiceTracker.close();
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
        }
        if (this.eventServiceTracker != null) {
            this.eventServiceTracker.close();
        }
        if (this.servletEventDispatcher != null) {
            this.servletEventDispatcher.destroy();
        }
        try {
            this.configExecutor.shutdown();
            LOG.debug("...entering 20 seconds grace period...");
            this.configExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            this.configExecutor.shutdownNow();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info("Pax Web stopped");
    }

    private void createManagedService(BundleContext context) {
        ManagedService service = new ManagedService(){

            public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
                Activator.this.scheduleUpdateConfig(configuration);
            }
        };
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.ops4j.pax.web");
        context.registerService(ManagedService.class, (Object)service, props);
        if (context.getServiceReference(ConfigurationAdmin.class.getName()) == null) {
            try {
                service.updated(null);
            }
            catch (ConfigurationException ignore) {
                LOG.error("Internal error. Cannot set initial configuration resolver.", (Throwable)ignore);
            }
        }
    }

    protected boolean same(Dictionary<String, ?> cfg1, Dictionary<String, ?> cfg2) {
        if (cfg1 == null) {
            return cfg2 == null;
        }
        if (cfg2 == null) {
            return false;
        }
        if (cfg1.size() != cfg2.size()) {
            return false;
        }
        boolean result = true;
        Enumeration<String> keys = cfg1.keys();
        while (result && keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object v1 = cfg1.get(key);
            Object v2 = cfg2.get(key);
            result = this.same(v1, v2);
        }
        return result;
    }

    protected boolean same(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1 == v2 || v1.equals(v2);
    }

    private void scheduleUpdateConfig(final Dictionary<String, ?> configuration) {
        this.configExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Activator.this.updateController(configuration, Activator.this.factory);
            }
        });
    }

    private void scheduleUpdateFactory(final ServerControllerFactory controllerFactory) {
        Future<?> future = this.configExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Activator.this.updateController(Activator.this.config, controllerFactory);
            }
        });
        if (controllerFactory == null) {
            try {
                future.get(20L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.info("Error when updating factory: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void updateController(Dictionary<String, ?> dictionary, ServerControllerFactory controllerFactory) {
        if (!this.initialConfigSet) {
            this.initialConfigSet = true;
            this.config = dictionary;
            this.factory = controllerFactory;
            this.dynamicsServiceTracker = new ServiceTracker(this.bundleContext, ServerControllerFactory.class, (ServiceTrackerCustomizer)new DynamicsServiceTrackerCustomizer());
            this.dynamicsServiceTracker.open();
            return;
        }
        if (this.same(dictionary, this.config) && this.same(controllerFactory, this.factory)) {
            return;
        }
        if (this.httpServiceFactoryReg != null) {
            this.httpServiceFactoryReg.unregister();
            this.httpServiceFactoryReg = null;
        }
        if (this.serverController != null) {
            this.serverController.stop();
            this.serverController = null;
        }
        if (controllerFactory != null) {
            try {
                BundleContextPropertyResolver tmpResolver = new BundleContextPropertyResolver(this.bundleContext, new DefaultPropertyResolver());
                FallbackPropertyResolver resolver = dictionary != null ? new DictionaryPropertyResolver(dictionary, tmpResolver) : tmpResolver;
                ConfigurationImpl configuration = new ConfigurationImpl(resolver);
                final ServerModel serverModel = new ServerModel();
                this.serverController = controllerFactory.createServerController(serverModel);
                this.serverController.configure((Configuration)configuration);
                Dictionary<String, Object> props = this.determineServiceProperties(dictionary, configuration, this.serverController.getHttpPort(), this.serverController.getHttpSecurePort());
                this.httpServiceFactoryReg = this.bundleContext.registerService(new String[]{HttpService.class.getName(), WebContainer.class.getName()}, (Object)new HttpServiceFactoryImpl(){

                    @Override
                    HttpService createService(Bundle bundle) {
                        return new HttpServiceProxy(new HttpServiceStarted(bundle, Activator.this.serverController, serverModel, Activator.this.servletEventDispatcher));
                    }
                }, props);
                if (!this.serverController.isStarted()) {
                    while (!this.serverController.isConfigured()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("caught interruptexception while waiting for configuration", (Throwable)e);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    this.serverController.start();
                }
            }
            catch (Throwable t) {
                LOG.error("Unable to start pax web server: " + t.getMessage(), t);
            }
        }
        this.factory = controllerFactory;
        this.config = dictionary;
    }

    private Dictionary<String, Object> determineServiceProperties(Dictionary<String, ?> managedConfig, Configuration configuration, Integer httpPort, Integer httpSecurePort) {
        Hashtable<String, Object> toPropagate = new Hashtable<String, Object>();
        if (managedConfig != null && !managedConfig.isEmpty()) {
            Enumeration<String> enumeration = managedConfig.keys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                toPropagate.put(key, managedConfig.get(key));
            }
        }
        this.setProperty(toPropagate, "org.osgi.service.http.enabled", configuration.isHttpEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port", configuration.getHttpPort());
        this.setProperty(toPropagate, "org.osgi.service.http.connector.name", configuration.getHttpConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.enabled", configuration.isHttpSecureEnabled());
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", configuration.getHttpSecurePort());
        this.setProperty(toPropagate, "org.osgi.service.http.secure.connector.name", configuration.getHttpSecureConnectorName());
        this.setProperty(toPropagate, "org.osgi.service.http.useNIO", configuration.useNIO());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthneeded", configuration.isClientAuthNeeded());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.clientauthwanted", configuration.isClientAuthWanted());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore", configuration.getSslKeystore());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keystore.type", configuration.getSslKeystoreType());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.password", configuration.getSslPassword());
        this.setProperty(toPropagate, "org.ops4j.pax.web.ssl.keypassword", configuration.getSslKeyPassword());
        this.setProperty(toPropagate, "javax.servlet.context.tempdir", configuration.getTemporaryDirectory());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.timeout", configuration.getSessionTimeout());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.url", configuration.getSessionUrl());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.cookie", configuration.getSessionCookie());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.domain", configuration.getSessionDomain());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.path", configuration.getSessionPath());
        this.setProperty(toPropagate, "org.ops4j.pax.web.session.cookie.secure", configuration.getSessionCookieSecure());
        this.setProperty(toPropagate, "org.ops4j.pax.web.worker.name", configuration.getWorkerName());
        this.setProperty(toPropagate, "org.ops4j.pax.web.listening.addresses", configuration.getListeningAddresses());
        this.setProperty(toPropagate, "org.osgi.service.http.port", httpPort);
        this.setProperty(toPropagate, "org.osgi.service.http.port.secure", httpSecurePort);
        this.setProperty(toPropagate, "org.ops4j.pax.web.config.file", configuration.getConfigurationDir());
        this.setProperty(toPropagate, "org.ops4j.pax.web.config.url", configuration.getConfigurationURL());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.format", configuration.getLogNCSAFormat());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.retaindays", configuration.getLogNCSARetainDays());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.append", configuration.isLogNCSAAppend());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.extended", configuration.isLogNCSAExtended());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.dispatch", configuration.isLogNCSADispatch());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.dispatch", configuration.isLogNCSADispatch());
        this.setProperty(toPropagate, "org.ops4j.pax.web.log.ncsa.logtimezone", configuration.getLogNCSATimeZone());
        if (SupportUtils.isJSPAvailable()) {
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.check.interval", configuration.getJspCheckInterval());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.debug.info", configuration.getJspClassDebugInfo());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.development", configuration.getJspDevelopment());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.enable.pooling", configuration.getJspEnablePooling());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.ie.classid", configuration.getJspIeClassId());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.java.encoding", configuration.getJspJavaEncoding());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.keep.generated", configuration.getJspKeepgenerated());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.log.verbosity.level", configuration.getJspLogVerbosityLevel());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.mapped.file", configuration.getJspMappedfile());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.scratch.dir", configuration.getJspScratchDir());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.tagpool.max.size", configuration.getJspTagpoolMaxSize());
            this.setProperty(toPropagate, "org.ops4j.pax.web.jsp.precompilation", configuration.getJspPrecompilation());
        }
        return toPropagate;
    }

    private void setProperty(Hashtable<String, Object> properties, String name, Object value) {
        if (value != null) {
            if (value instanceof File) {
                properties.put(name, ((File)value).getAbsolutePath());
            } else if (value instanceof Object[]) {
                properties.put(name, Activator.join(",", (Object[])value));
            } else {
                properties.put(name, value.toString());
            }
        } else {
            properties.remove(name);
        }
    }

    private static String join(String token, Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < array.length - 1; ++x) {
            if (array[x] != null) {
                sb.append(array[x].toString());
            } else {
                sb.append("null");
            }
            sb.append(token);
        }
        sb.append(array[array.length - 1]);
        return sb.toString();
    }

    private class DynamicsServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServerControllerFactory, ServerControllerFactory> {
        private DynamicsServiceTrackerCustomizer() {
        }

        public ServerControllerFactory addingService(ServiceReference<ServerControllerFactory> reference) {
            ServerControllerFactory controllerFactory = (ServerControllerFactory)Activator.this.bundleContext.getService(reference);
            Activator.this.scheduleUpdateFactory(controllerFactory);
            return controllerFactory;
        }

        public void modifiedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
        }

        public void removedService(ServiceReference<ServerControllerFactory> reference, ServerControllerFactory service) {
            if (Activator.this.bundleContext != null) {
                Activator.this.bundleContext.ungetService(reference);
            }
            Activator.this.scheduleUpdateFactory(null);
        }
    }
}

