/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final PropertyResolver propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.propertyResolver = propertyResolver;
    }

    public Integer getHttpPort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port");
    }

    public String getHttpConnectorName() {
        return this.getResolvedStringProperty("org.osgi.service.http.connector.name");
    }

    public Boolean useNIO() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.useNIO");
    }

    public Boolean checkForwardedHeaders() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.checkForwardedHeaders");
    }

    public Boolean isClientAuthNeeded() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthneeded");
    }

    public Boolean isClientAuthWanted() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthwanted");
    }

    public Boolean isHttpEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.enabled");
    }

    public Integer getHttpSecurePort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port.secure");
    }

    public String getHttpSecureConnectorName() {
        return this.getResolvedStringProperty("org.osgi.service.http.secure.connector.name");
    }

    public Boolean isHttpSecureEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.secure.enabled");
    }

    public String getSslKeystore() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore");
    }

    public String getSslKeystoreType() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore.type");
    }

    public String getSslPassword() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.password");
    }

    public String getSslKeyPassword() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keypassword");
    }

    public File getTemporaryDirectory() {
        try {
            if (!this.contains("javax.servlet.context.tempdir")) {
                String tempDirPath = this.propertyResolver.get("javax.servlet.context.tempdir");
                File tempDir = null;
                if (tempDirPath != null && !(tempDir = tempDirPath.startsWith("file:") ? new File(new URI(tempDirPath)) : new File(tempDirPath)).exists()) {
                    tempDir.mkdirs();
                }
                return this.set("javax.servlet.context.tempdir", tempDir);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property javax.servlet.context.tempdir has failed");
        }
        return (File)this.get("javax.servlet.context.tempdir");
    }

    public File getConfigurationDir() {
        try {
            if (!this.contains("org.ops4j.pax.web.config.file")) {
                String serverConfigurationFileName = this.propertyResolver.get("org.ops4j.pax.web.config.file");
                File configurationFile = serverConfigurationFileName.startsWith("file:") ? new File(new URI(serverConfigurationFileName)) : new File(serverConfigurationFileName);
                if (!configurationFile.exists()) {
                    LOG.debug("Reading from configured path for the configuration property org.ops4j.pax.web.config.file has failed");
                }
                return this.set("org.ops4j.pax.web.config.file", configurationFile);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.config.file has failed");
        }
        return null;
    }

    public URL getConfigurationURL() {
        try {
            if (!this.contains("org.ops4j.pax.web.config.url")) {
                String serverConfigurationURL = this.propertyResolver.get("org.ops4j.pax.web.config.url");
                URL configurationURL = new URL(serverConfigurationURL);
                return this.set("org.ops4j.pax.web.config.url", configurationURL);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.config.url has failed");
        }
        return null;
    }

    public Integer getSessionTimeout() {
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.session.timeout");
    }

    public String getSessionCookie() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.cookie");
    }

    public String getSessionDomain() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.domain");
    }

    public String getSessionPath() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.path");
    }

    public String getSessionUrl() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.url");
    }

    public Boolean getSessionCookieHttpOnly() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.session.cookie.httpOnly");
    }

    public Boolean getSessionCookieSecure() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.session.cookie.secure");
    }

    public Boolean getSessionLazyLoad() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.session.lazyload");
    }

    public String getSessionStoreDirectory() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.storedirectory");
    }

    public String getWorkerName() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.worker.name");
    }

    public String[] getListeningAddresses() {
        try {
            if (!this.contains("org.ops4j.pax.web.listening.addresses")) {
                String interfacesString = this.propertyResolver.get("org.ops4j.pax.web.listening.addresses");
                String[] interfaces = interfacesString == null ? new String[]{} : interfacesString.split(",");
                return this.set("org.ops4j.pax.web.listening.addresses", interfaces);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.listening.addresses has failed");
        }
        return (String[])this.get("org.ops4j.pax.web.listening.addresses");
    }

    public String getJspScratchDir() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.scratch.dir");
    }

    public Integer getJspCheckInterval() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.check.interval");
    }

    public Boolean getJspClassDebugInfo() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.debug.info");
    }

    public Boolean getJspDevelopment() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.development");
    }

    public Boolean getJspEnablePooling() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.enable.pooling");
    }

    public String getJspIeClassId() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.ie.classid");
    }

    public String getJspJavaEncoding() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.java.encoding");
    }

    public Boolean getJspKeepgenerated() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.keep.generated");
    }

    public String getJspLogVerbosityLevel() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.log.verbosity.level");
    }

    public Boolean getJspMappedfile() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.mapped.file");
    }

    public Integer getJspTagpoolMaxSize() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.tagpool.max.size");
    }

    public Boolean getJspPrecompilation() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.precompilation");
    }

    public Boolean isLogNCSAFormatEnabled() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.enabled");
    }

    public String getLogNCSAFormat() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.format");
    }

    public String getLogNCSARetainDays() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.retaindays");
    }

    public Boolean isLogNCSAAppend() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.append");
    }

    public Boolean isLogNCSAExtended() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.extended");
    }

    public Boolean isLogNCSADispatch() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.dispatch");
    }

    public String getLogNCSATimeZone() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.logtimezone");
    }

    public String getLogNCSADirectory() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.directory");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "http enabled=" + this.isHttpEnabled() + ",http port=" + this.getHttpPort() + ",http secure enabled=" + this.isHttpSecureEnabled() + ",http secure port=" + this.getHttpSecurePort() + ",ssl keystore=" + this.getSslKeystore() + ",ssl keystoreType=" + this.getSslKeystoreType() + ",session timeout=" + this.getSessionTimeout() + ",session url=" + this.getSessionUrl() + ",session cookie=" + this.getSessionCookie() + ",session cookie httpOnly=" + this.getSessionCookieHttpOnly() + ",worker name=" + this.getWorkerName() + ",listening addresses=" + Arrays.toString(this.getListeningAddresses()) + "}";
    }

    private String getResolvedStringProperty(String property) {
        try {
            if (!this.contains(property)) {
                return this.set(property, this.propertyResolver.get(property));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (String)this.get(property);
    }

    private Boolean getResolvedBooleanProperty(String property) {
        try {
            if (!this.contains(property)) {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Boolean.valueOf(resolvedProperty));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Boolean)this.get(property);
    }

    private Integer getResolvedIntegerProperty(String property) {
        try {
            if (!this.contains(property)) {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Integer.valueOf(this.propertyResolver.get(property)));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Integer)this.get(property);
    }

    public List<String> getVirtualHosts() {
        String connectorListString;
        LinkedList<String> virtualHosts = new LinkedList<String>();
        String virtualHostListString = this.getResolvedStringProperty("org.ops4j.pax.web.default.virtualhosts");
        if (virtualHostListString != null && virtualHostListString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = virtualHostListString.split(",")) {
                virtualHosts.add(virtualHost.trim());
            }
        }
        if ((connectorListString = this.getResolvedStringProperty("org.ops4j.pax.web.default.connectors")) != null && connectorListString.length() > 0) {
            String[] connectorArray;
            for (String connector : connectorArray = connectorListString.split(",")) {
                virtualHosts.add("@" + connector.trim());
            }
        }
        return virtualHosts;
    }

    public Boolean isLogNCSALatency() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.latency");
    }

    public Boolean isLogNCSACookies() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.cookies");
    }

    public Boolean isLogNCSAServer() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.server");
    }
}

