/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel {
    private static final Log LOG = LogFactory.getLog(ServerModel.class);
    private final Map<String, ServletModel> m_aliasMapping = new HashMap<String, ServletModel>();
    private final Set<Servlet> m_servlets = new HashSet<Servlet>();
    private final Map<String, UrlPattern> m_servletUrlPatterns = new HashMap<String, UrlPattern>();
    private final ConcurrentMap<String, UrlPattern> m_filterUrlPatterns = new ConcurrentHashMap<String, UrlPattern>();
    private final ConcurrentMap<HttpContext, Bundle> m_httpContexts = new ConcurrentHashMap<HttpContext, Bundle>();
    private final Lock m_servletLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletModel(ServletModel model) throws NamespaceException, ServletException {
        this.m_servletLock.lock();
        try {
            if (this.m_servlets.contains(model.getServlet())) {
                throw new ServletException("servlet already registered with a different alias");
            }
            if (model.getAlias() != null) {
                String alias = ServerModel.getFullPath(model.getContextModel(), model.getAlias());
                if (this.m_aliasMapping.containsKey(alias)) {
                    throw new NamespaceException("alias is already in use in this or another context");
                }
                this.m_aliasMapping.put(alias, model);
            }
            this.m_servlets.add(model.getServlet());
            for (String urlPattern : model.getUrlPatterns()) {
                this.m_servletUrlPatterns.put(model.getId() + urlPattern, new UrlPattern(ServerModel.getFullPath(model.getContextModel(), urlPattern), model));
            }
        }
        finally {
            this.m_servletLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletModel(ServletModel model) {
        this.m_servletLock.lock();
        try {
            if (model.getAlias() != null) {
                this.m_aliasMapping.remove(ServerModel.getFullPath(model.getContextModel(), model.getAlias()));
            }
            this.m_servlets.remove(model.getServlet());
            if (model.getUrlPatterns() != null) {
                for (String urlPattern : model.getUrlPatterns()) {
                    this.m_servletUrlPatterns.remove(model.getId() + urlPattern);
                }
            }
        }
        finally {
            this.m_servletLock.unlock();
        }
    }

    public void addFilterModel(FilterModel model) {
        if (model.getUrlPatterns() != null) {
            for (String urlPattern : model.getUrlPatterns()) {
                UrlPattern newUrlPattern = new UrlPattern(ServerModel.getFullPath(model.getContextModel(), urlPattern), model);
                UrlPattern existingPattern = this.m_filterUrlPatterns.putIfAbsent(model.getId() + urlPattern, newUrlPattern);
                if (existingPattern == null) continue;
                LOG.error("Internal error (please report): Cannot associate url mapping " + model.getId() + urlPattern + " to " + newUrlPattern + " because is already associated to " + existingPattern);
            }
        }
    }

    public void removeFilterModel(FilterModel model) {
        if (model.getUrlPatterns() != null) {
            for (String urlPattern : model.getUrlPatterns()) {
                this.m_filterUrlPatterns.remove(model.getId() + urlPattern);
            }
        }
    }

    public void associateHttpContext(HttpContext httpContext, Bundle bundle, boolean allowReAsssociation) {
        Bundle currentBundle = this.m_httpContexts.putIfAbsent(httpContext, bundle);
        if (allowReAsssociation && currentBundle != null && currentBundle != bundle) {
            throw new IllegalStateException("Http context " + httpContext + " is already associated to bundle " + currentBundle);
        }
    }

    public void deassociateHttpContexts(Bundle bundle) {
        for (Map.Entry entry : this.m_httpContexts.entrySet()) {
            if (entry.getValue() != bundle) continue;
            this.m_httpContexts.remove(entry.getKey());
        }
    }

    public ContextModel matchPathToContext(String path) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug("Matching [" + path + "]...");
        }
        this.m_servletLock.lock();
        UrlPattern urlPattern = ServerModel.matchPathToContext(this.m_servletUrlPatterns.values(), path);
        this.m_servletLock.unlock();
        if (urlPattern == null) {
            urlPattern = ServerModel.matchPathToContext(this.m_filterUrlPatterns.values(), path);
        }
        ContextModel matched = null;
        if (urlPattern != null) {
            matched = urlPattern.getModel().getContextModel();
        }
        if (debug) {
            if (matched != null) {
                LOG.debug("Path [" + path + "] matched to " + urlPattern);
            } else {
                LOG.debug("Path [" + path + "] does not match any context");
            }
        }
        return matched;
    }

    private static UrlPattern matchPathToContext(Collection<UrlPattern> urlPatterns, String path) {
        UrlPattern matched = null;
        if (urlPatterns != null) {
            for (UrlPattern urlPattern : urlPatterns) {
                if (matched != null && !urlPattern.isBetterMatchThen(matched)) continue;
                if (urlPattern.getPattern().matcher(path).matches()) {
                    matched = urlPattern;
                    continue;
                }
                if (path.endsWith("/") || !urlPattern.getPattern().matcher(path + "/").matches()) continue;
                matched = urlPattern;
            }
        }
        return matched;
    }

    private static String getFullPath(ContextModel model, String path) {
        String fullPath = path.trim();
        if (model.getContextName().length() > 0) {
            fullPath = "/" + model.getContextName();
            if (!"/".equals(path.trim())) {
                fullPath = fullPath + path;
            }
        }
        return fullPath;
    }

    private static class UrlPattern {
        private final Pattern m_pattern;
        private final Model m_model;

        UrlPattern(String pattern, Model model) {
            this.m_model = model;
            String patternToUse = pattern;
            if (!patternToUse.contains("*")) {
                patternToUse = patternToUse + (pattern.endsWith("/") ? "*" : "/*");
            }
            patternToUse = patternToUse.replace(".", "\\.");
            patternToUse = patternToUse.replace("*", ".*");
            this.m_pattern = Pattern.compile(patternToUse);
        }

        Pattern getPattern() {
            return this.m_pattern;
        }

        Model getModel() {
            return this.m_model;
        }

        public boolean isBetterMatchThen(UrlPattern urlPattern) {
            return urlPattern == null || this != urlPattern && this.m_pattern.pattern().length() > urlPattern.m_pattern.pattern().length();
        }

        public String toString() {
            return new StringBuffer().append("{").append("pattern=").append(this.m_pattern.pattern()).append(",model=").append(this.m_model).append("}").toString();
        }
    }
}

