/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi;

import javax.servlet.Servlet;
import org.osgi.framework.Bundle;

public class ServletEvent {
    private boolean replay;
    private int type;
    private Bundle bundle;
    private long timestamp;
    private String alias;
    private String servletName;
    private String[] urlParameter;
    private Servlet servlet;
    public static final int DEPLOYING = 1;
    public static final int DEPLOYED = 2;
    public static final int UNDEPLOYING = 3;
    public static final int UNDEPLOYED = 4;
    public static final int FAILED = 5;
    public static final int WAITING = 6;

    public ServletEvent(ServletEvent event, boolean replay) {
        this.type = event.getType();
        this.bundle = event.getBundle();
        this.alias = event.getAlias();
        this.servletName = event.getServletName();
        this.urlParameter = event.getUrlParameter();
        this.servlet = event.getServlet();
        this.timestamp = event.getTimestamp();
        this.replay = replay;
    }

    public ServletEvent(int type, Bundle bundle, String alias, String servletName, String[] urlParameter, Servlet servlet) {
        this.type = type;
        this.bundle = bundle;
        this.alias = alias;
        this.servletName = servletName;
        this.urlParameter = urlParameter;
        this.servlet = servlet;
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isReplay() {
        return this.replay;
    }

    public int getType() {
        return this.type;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String[] getUrlParameter() {
        return this.urlParameter;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public String toString() {
        return "ServletEvent [replay=" + this.replay + ", type=" + this.type + ", bundle=" + this.bundle + ", timestamp=" + this.timestamp + ", alias=" + this.alias + ", servletName=" + this.servletName + ", urlParameter=" + this.urlParameter + ", servlet=" + this.servlet + "]";
    }
}

