/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.digester.Digester;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.tomcat.internal.ConfigFileNotFoundException;
import org.ops4j.pax.web.service.tomcat.internal.ConfigFileParsingException;
import org.ops4j.pax.web.service.tomcat.internal.HttpServiceContext;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class EmbeddedTomcat
extends Tomcat {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedTomcat.class);
    public static final String SERVER_CONFIG_FILE_NAME = "tomcat-server.xml";
    private File configurationDirectory;
    private Integer configurationSessionTimeout;
    private String configurationSessionCookie;
    private String configurationSessionUrl;
    private Boolean configurationSessionCookieHttpOnly;
    private String configurationWorkerName;

    private EmbeddedTomcat() {
    }

    static EmbeddedTomcat newEmbeddedTomcat(Configuration configuration) {
        EmbeddedTomcat result = new EmbeddedTomcat();
        result.configure(configuration);
        return result;
    }

    void configure(Configuration configuration) {
        long start = System.nanoTime();
        this.initBaseDir(configuration);
        Digester digester = new FakeCatalina().createStartDigester();
        digester.push((Object)this);
        File configurationFile = new File(configuration.getConfigurationDir(), SERVER_CONFIG_FILE_NAME);
        if (configurationFile.exists()) {
            FileInputStream configurationStream = null;
            try {
                configurationStream = new FileInputStream(configurationFile);
                digester.parse((InputStream)configurationStream);
                long elapsed = start - System.nanoTime();
                if (LOG.isInfoEnabled()) {
                    LOG.info("configuration processed in {} ms", (Object)(elapsed / 1000000L));
                }
            }
            catch (FileNotFoundException e) {
                throw new ConfigFileNotFoundException(configurationFile, (Throwable)e);
            }
            catch (IOException e) {
                throw new ConfigFileParsingException(configurationFile, (Throwable)e);
            }
            catch (SAXException e) {
                throw new ConfigFileParsingException(configurationFile, (Throwable)e);
            }
            finally {
                if (configurationStream != null) {
                    try {
                        ((InputStream)configurationStream).close();
                    }
                    catch (IOException e) {
                        LOG.debug("cannot close the configuration file '{}' properly", (Object)configurationFile, (Object)e);
                    }
                }
            }
        }
        this.mergeConfiguration(configuration);
    }

    private void mergeConfiguration(Configuration configuration) {
        Connector[] connectors;
        LOG.debug("Start merging configuration");
        Connector httpConnector = null;
        Connector httpSecureConnector = null;
        String[] addresses = configuration.getListeningAddresses();
        if (addresses == null || addresses.length == 0) {
            addresses = new String[]{null};
        }
        HashMap<String, File> attributes = new HashMap<String, File>();
        attributes.put("javax.servlet.context.tempdir", configuration.getTemporaryDirectory());
        this.configurationDirectory = configuration.getConfigurationDir();
        this.configurationSessionTimeout = configuration.getSessionTimeout();
        this.configurationSessionCookie = configuration.getSessionCookie();
        this.configurationSessionUrl = configuration.getSessionUrl();
        this.configurationSessionCookieHttpOnly = configuration.getSessionCookieHttpOnly();
        this.configurationWorkerName = configuration.getWorkerName();
        for (int i = 0; i < addresses.length; ++i) {
            LOG.debug("Loop {} of {}", (Object)i, (Object)addresses.length);
            String address = addresses[i];
            LOG.debug("configuring host with address: {}", (Object)address);
            Host host = null;
            if (i == 0) {
                host = this.getHost();
                LOG.debug("retrieved existing host: {}", (Object)host);
            } else {
                host = new StandardHost();
                LOG.debug("created a new StandardHost: {}", (Object)host);
            }
            host.setName(addresses[i]);
            host.setAutoDeploy(false);
            LOG.debug("re-configured host to {}", (Object)host);
            if (i == 0) {
                this.getEngine().setDefaultHost(address);
            }
            if (i <= 0) continue;
            this.getEngine().addChild((Container)host);
        }
        Integer httpPort = configuration.getHttpPort();
        Boolean useNIO = configuration.useNIO();
        Integer httpSecurePort = configuration.getHttpSecurePort();
        if (configuration.isHttpEnabled().booleanValue()) {
            LOG.debug("HttpEnabled");
            connectors = this.getService().findConnectors();
            boolean masterConnectorFound = false;
            if (connectors != null && connectors.length > 0) {
                Connector backupConnector = null;
                for (Connector connector : connectors) {
                    if (!(connector instanceof Connector) || connector.getSecure()) continue;
                    if (httpPort.intValue() == connector.getPort() && "HTTP/1.1".equalsIgnoreCase(connector.getProtocol())) {
                        if (httpConnector == null) {
                            httpConnector = connector;
                        }
                        this.configureConnector(configuration, httpPort, useNIO, connector);
                        masterConnectorFound = true;
                        LOG.debug("master connector found, will alter it");
                        continue;
                    }
                    if (backupConnector != null) continue;
                    backupConnector = connector;
                    LOG.debug("backup connector found");
                }
                if (httpConnector == null && backupConnector != null) {
                    LOG.debug("No master connector found will use backup one");
                    httpConnector = backupConnector;
                }
            }
            if (!masterConnectorFound) {
                LOG.debug("No Master connector found create a new one");
                this.connector = new Connector("HTTP/1.1");
                LOG.debug("Reconfiguring master connector");
                this.configureConnector(configuration, httpPort, useNIO, this.connector);
                if (httpConnector == null) {
                    httpConnector = this.connector;
                }
                this.service.addConnector(this.connector);
            }
        } else {
            LOG.debug("Http is disabled any existing http connector will be removed");
            connectors = this.getService().findConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    if (!(connector instanceof Connector) || connector.getSecure()) continue;
                    LOG.debug("Removing connector {}", (Object)connector);
                    this.getService().removeConnector(connector);
                }
            }
        }
        if (configuration.isHttpSecureEnabled().booleanValue()) {
            String sslPassword = configuration.getSslPassword();
            String sslKeyPassword = configuration.getSslKeyPassword();
            Connector[] connectors2 = this.getService().findConnectors();
            boolean masterSSLConnectorFound = false;
            if (connectors2 != null && connectors2.length > 0) {
                Connector backupConnector = null;
                for (Connector connector : connectors2) {
                    if (!connector.getSecure()) continue;
                    Connector sslCon = connector;
                    if (httpSecurePort.intValue() == connector.getPort()) {
                        httpSecureConnector = sslCon;
                        masterSSLConnectorFound = true;
                        this.configureSSLConnector(configuration, useNIO, httpSecurePort, sslCon);
                        continue;
                    }
                    if (backupConnector != null) continue;
                    backupConnector = connector;
                }
                if (httpSecureConnector == null && backupConnector != null) {
                    httpSecureConnector = backupConnector;
                }
            }
            if (!masterSSLConnectorFound) {
                if (sslPassword != null && sslKeyPassword != null) {
                    Connector secureConnector = new Connector("HTTPS/1.1");
                    this.configureSSLConnector(configuration, useNIO, httpSecurePort, secureConnector);
                    if (httpSecureConnector == null) {
                        httpSecureConnector = secureConnector;
                    }
                    this.getService().addConnector(httpSecureConnector);
                } else {
                    LOG.warn("SSL password and SSL keystore password must be set in order to enable SSL.");
                    LOG.warn("SSL connector will not be started");
                }
            }
        } else {
            connectors = this.getService().findConnectors();
            if (connectors != null) {
                for (Connector connector : connectors) {
                    if (!connector.getSecure()) continue;
                    this.getService().removeConnector(connector);
                }
            }
        }
    }

    private void configureSSLConnector(Configuration configuration, Boolean useNIO, Integer httpSecurePort, Connector secureConnector) {
        secureConnector.setPort(httpSecurePort.intValue());
        secureConnector.setSecure(true);
        secureConnector.setScheme("https");
        secureConnector.setProperty("SSLEnabled", "true");
        secureConnector.setProperty("keystoreFile", configuration.getSslKeystore());
        secureConnector.setProperty("keystorePass", configuration.getSslKeyPassword());
        secureConnector.setProperty("clientAuth", "false");
        secureConnector.setProperty("sslProtocol", "TLS");
        if (useNIO.booleanValue()) {
            secureConnector.setProtocolHandlerClassName(Http11NioProtocol.class.getName());
        } else {
            secureConnector.setProtocolHandlerClassName(Http11Protocol.class.getName());
        }
    }

    private void configureConnector(Configuration configuration, Integer httpPort, Boolean useNIO, Connector connector) {
        LOG.debug("Configuring connector {}", (Object)connector);
        connector.setScheme("http");
        connector.setPort(httpPort.intValue());
        if (configuration.isHttpSecureEnabled().booleanValue()) {
            connector.setRedirectPort(configuration.getHttpSecurePort().intValue());
        }
        if (useNIO.booleanValue()) {
            connector.setProtocolHandlerClassName(Http11NioProtocol.class.getName());
        } else {
            connector.setProtocolHandlerClassName(Http11Protocol.class.getName());
        }
        LOG.debug("configuration done: {}", (Object)connector);
    }

    private void initBaseDir(Configuration configuration) {
        this.setBaseDir(configuration.getTemporaryDirectory().getAbsolutePath());
    }

    String getBasedir() {
        return this.basedir;
    }

    Context findContext(String contextName) {
        return (Context)this.findContainer(contextName);
    }

    Container findContainer(String contextName) {
        return this.getHost().findChild(contextName);
    }

    public Context addContext(Map<String, String> contextParams, Map<String, Object> contextAttributes, String contextName, HttpContext httpContext, AccessControlContext accessControllerContext, Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers, URL jettyWebXmlURL, List<String> virtualHosts, List<String> connectors, String basedir) {
        this.silence(this.host, "/" + contextName);
        HttpServiceContext ctx = new HttpServiceContext();
        ctx.setName(contextName);
        ctx.setPath("/" + contextName);
        ctx.setDocBase(basedir);
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ctx.setSessionCookieName(this.configurationSessionCookie);
        ctx.setUseHttpOnly(this.configurationSessionCookieHttpOnly);
        ctx.setSessionTimeout(this.configurationSessionTimeout);
        ctx.setHttpContext(httpContext);
        if (containerInitializers != null) {
            for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : containerInitializers.entrySet()) {
                ctx.addServletContainerInitializer(entry.getKey(), entry.getValue());
            }
        }
        if (this.host == null) {
            this.getHost().addChild((Container)ctx);
        } else {
            this.host.addChild((Container)ctx);
        }
        try {
            ctx.stop();
        }
        catch (LifecycleException e) {
            LOG.error("context couldn't be started", (Throwable)e);
        }
        return ctx;
    }

    private void silence(Host host, String ctx) {
        String base = "org.apache.catalina.core.ContainerBase.[default].[";
        base = host == null ? base + this.getHost().getName() : base + host.getName();
        base = base + "].[";
        base = base + ctx;
        base = base + "]";
        LOG.warn(base);
    }

    private static class FakeCatalina
    extends Catalina {
        private FakeCatalina() {
        }

        protected Digester createStartDigester() {
            return super.createStartDigester();
        }
    }
}

