/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TomcatInterceptFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain originalChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String pathInfo = request.getPathInfo();
            List<Filter> filters = this.getFiltersRegisteredForPath(pathInfo);
            DelegatingFilterChain filterChain = new DelegatingFilterChain(filters);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (filterChain.proceedRequest) {
                Servlet servlet = this.getMostSpecificServletForPath(pathInfo);
                if (servlet != null) {
                    servlet.service((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                URL resourceUrl = this.getMostSpecificResourceURLForPath(pathInfo);
                if (resourceUrl != null) {
                    URLConnection connection = resourceUrl.openConnection();
                    String contentType = connection.getContentType();
                    if (contentType != null) {
                        response.setContentType(contentType);
                    }
                    InputStream inputStream = connection.getInputStream();
                    try {
                        ServletOutputStream outputstream = response.getOutputStream();
                        this.copy(inputStream, outputstream);
                        outputstream.flush();
                        outputstream.close();
                    }
                    finally {
                        inputStream.close();
                    }
                    return;
                }
            } else {
                return;
            }
        }
        originalChain.doFilter(servletRequest, servletResponse);
    }

    protected abstract URL getMostSpecificResourceURLForPath(String var1);

    protected abstract Servlet getMostSpecificServletForPath(String var1);

    protected abstract List<Filter> getFiltersRegisteredForPath(String var1);

    protected abstract void copy(InputStream var1, ServletOutputStream var2);

    private static final class DelegatingFilterChain
    implements FilterChain {
        private final List<Filter> filters;
        private int index = 0;
        private boolean proceedRequest = false;

        private DelegatingFilterChain(List<Filter> filters) {
            this.filters = filters;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.index < this.filters.size()) {
                Filter filter = this.filters.get(this.index);
                ++this.index;
                filter.doFilter(request, response, (FilterChain)this);
            } else {
                this.proceedRequest = true;
            }
        }
    }
}

