/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.startup.Tomcat;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleUtils;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.ServletContextManager;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.tomcat.internal.AddErrorPageException;
import org.ops4j.pax.web.service.tomcat.internal.AddFilterException;
import org.ops4j.pax.web.service.tomcat.internal.EmbeddedTomcat;
import org.ops4j.pax.web.service.tomcat.internal.RemoveContextException;
import org.ops4j.pax.web.service.tomcat.internal.RemoveErrorPageException;
import org.ops4j.pax.web.service.tomcat.internal.RemoveEventListenerException;
import org.ops4j.pax.web.service.tomcat.internal.ServerStartException;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;
import org.ops4j.pax.web.service.tomcat.internal.TomcatRemoveServletException;
import org.ops4j.pax.web.service.tomcat.internal.TomcatResourceServlet;
import org.ops4j.pax.web.service.tomcat.internal.TomcatServletContextWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TomcatServerWrapper
implements ServerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatServerWrapper.class);
    private final EmbeddedTomcat m_server;
    private final Map<HttpContext, Context> m_contexts = new ConcurrentHashMap<HttpContext, Context>();
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private ServiceRegistration<ServletContext> servletContextService;
    private Map<String, Object> contextAttributes;

    private TomcatServerWrapper(EmbeddedTomcat server) {
        NullArgumentException.validateNotNull((Object)server, "server");
        this.m_server = server;
        ((ContainerBase)this.m_server.getHost()).setStartChildren(false);
    }

    static ServerWrapper getInstance(EmbeddedTomcat server) {
        return new TomcatServerWrapper(server);
    }

    @Override
    public void start() {
        LOG.debug("start server");
        try {
            long t1 = System.nanoTime();
            this.m_server.getHost();
            this.m_server.start();
            long t2 = System.nanoTime();
            if (LOG.isInfoEnabled()) {
                LOG.info("TomCat server startup in " + (t2 - t1) / 1000000L + " ms");
            }
        }
        catch (LifecycleException e) {
            throw new ServerStartException(this.m_server.getServer().getInfo(), e);
        }
    }

    @Override
    public void stop() {
        LOG.debug("stop server");
        LifecycleState state = this.m_server.getServer().getState();
        if (LifecycleState.STOPPING_PREP.compareTo((Enum)state) <= 0 && LifecycleState.DESTROYED.compareTo((Enum)state) >= 0) {
            throw new IllegalStateException("stop already called!");
        }
        try {
            this.m_server.stop();
            this.m_server.destroy();
        }
        catch (Throwable e) {
            LOG.error("LifecycleException caught {}", e);
        }
    }

    @Override
    public void addServlet(ServletModel model) {
        LOG.debug("add servlet [{}]", (Object)model);
        Context context = this.findOrCreateContext(model.getContextModel());
        String servletName = model.getName();
        Object sw = null;
        sw = model.getServlet() == null ? context.createWrapper() : new Tomcat.ExistingStandardWrapper(model.getServlet()){

            protected void initInternal() throws LifecycleException {
                super.initInternal();
                try {
                    super.loadServlet();
                }
                catch (ServletException e) {
                    e.printStackTrace();
                }
            }
        };
        sw.setName(servletName);
        context.addChild((Container)sw);
        this.addServletMappings(context, servletName, model.getUrlPatterns());
        this.addInitParameters((Wrapper)sw, model.getInitParams());
    }

    @Override
    public void removeServlet(ServletModel model) {
        LOG.debug("remove servlet [{}]", (Object)model);
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new TomcatRemoveServletException("cannot remove servlet cannot find the associated container: " + model);
        }
        Container servlet = context.findChild(model.getName());
        if (servlet == null) {
            throw new TomcatRemoveServletException("cannot find the servlet to remove: " + model);
        }
        context.removeChild(servlet);
    }

    @Override
    public void removeContext(HttpContext httpContext) {
        LOG.debug("remove context [{}]", (Object)httpContext);
        try {
            if (this.servletContextService != null) {
                this.servletContextService.unregister();
            }
        }
        catch (IllegalStateException e) {
            LOG.info("ServletContext service already removed");
        }
        Context context = this.m_contexts.remove(httpContext);
        this.m_server.getHost().removeChild((Container)context);
        if (context == null) {
            throw new RemoveContextException("cannot remove the context because it does not exist: " + httpContext);
        }
        try {
            LifecycleState state = context.getState();
            if (LifecycleState.DESTROYED != state || LifecycleState.DESTROYING != state) {
                context.destroy();
            }
        }
        catch (LifecycleException e) {
            throw new RemoveContextException("cannot destroy the context: " + httpContext, e);
        }
    }

    @Override
    public void addEventListener(EventListenerModel eventListenerModel) {
        LOG.debug("add event listener: [{}]", (Object)eventListenerModel);
        ServletContext servletContext = this.findOrCreateServletContext((Model)eventListenerModel);
        servletContext.addListener(eventListenerModel.getEventListener());
    }

    private ServletContext findOrCreateServletContext(Model model) {
        Context context = this.findOrCreateContext(model);
        return context.getServletContext();
    }

    @Override
    public void removeEventListener(EventListenerModel eventListenerModel) {
        LOG.debug("remove event listener: [{}]", (Object)eventListenerModel);
        NullArgumentException.validateNotNull(eventListenerModel, "eventListenerModel");
        NullArgumentException.validateNotNull(eventListenerModel.getEventListener(), "eventListenerModel#weventListener");
        Context context = this.findOrCreateContext((Model)eventListenerModel);
        if (!this.removeApplicationEventListener(context, eventListenerModel.getEventListener()) && !this.removeApplicationLifecycleListener(context, eventListenerModel.getEventListener())) {
            throw new RemoveEventListenerException("cannot remove the event lister it is a not support class : " + eventListenerModel);
        }
    }

    private boolean removeApplicationLifecycleListener(Context context, EventListener eventListener) {
        if (!this.isApplicationLifecycleListener(eventListener)) {
            return false;
        }
        List<Object> applicationLifecycleListeners = Arrays.asList(context.getApplicationLifecycleListeners());
        if (applicationLifecycleListeners.remove(eventListener)) {
            context.setApplicationLifecycleListeners(applicationLifecycleListeners.toArray());
            return true;
        }
        return false;
    }

    private boolean isApplicationLifecycleListener(EventListener eventListener) {
        return eventListener instanceof HttpSessionListener || eventListener instanceof ServletContextListener;
    }

    private boolean removeApplicationEventListener(Context context, EventListener eventListener) {
        if (!this.isApplicationEventListener(eventListener)) {
            return false;
        }
        List<Object> applicationEventListener = Arrays.asList(context.getApplicationEventListeners());
        if (applicationEventListener.remove(eventListener)) {
            context.setApplicationEventListeners(applicationEventListener.toArray());
            return true;
        }
        return false;
    }

    private boolean isApplicationEventListener(EventListener eventListener) {
        return eventListener instanceof ServletContextAttributeListener || eventListener instanceof ServletRequestListener || eventListener instanceof ServletRequestAttributeListener || eventListener instanceof HttpSessionAttributeListener;
    }

    @Override
    public void addFilter(FilterModel filterModel) {
        LOG.debug("add filter [{}]", (Object)filterModel);
        ServletContext servletContext = this.findOrCreateServletContext((Model)filterModel);
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter(filterModel.getName(), filterModel.getFilter());
        if (filterModel.getServletNames() != null) {
            filterRegistration.addMappingForServletNames(this.getDispatcherTypes(filterModel), false, filterModel.getServletNames());
        } else if (filterModel.getUrlPatterns() != null) {
            filterRegistration.addMappingForServletNames(this.getDispatcherTypes(filterModel), false, filterModel.getUrlPatterns());
        } else {
            throw new AddFilterException("cannot add filter to the context; at least a not empty list of servlet names or URL patterns in exclusive mode must be provided: " + filterModel);
        }
        filterRegistration.setInitParameters(filterModel.getInitParams());
    }

    private EnumSet<DispatcherType> getDispatcherTypes(FilterModel filterModel) {
        ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>(DispatcherType.values().length);
        for (String dispatcherType : filterModel.getDispatcher()) {
            dispatcherTypes.add(DispatcherType.valueOf((String)dispatcherType.toUpperCase()));
        }
        EnumSet<DispatcherType> result = EnumSet.copyOf(dispatcherTypes);
        return result;
    }

    @Override
    public void removeFilter(FilterModel filterModel) {
        throw new UnsupportedOperationException("not yet implemented :(");
    }

    @Override
    public void addErrorPage(ErrorPageModel model) {
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new AddErrorPageException("cannot retrieve the associated context: " + model);
        }
        ErrorPage errorPage = this.createErrorPage(model);
        context.addErrorPage(errorPage);
    }

    private ErrorPage createErrorPage(ErrorPageModel model) {
        NullArgumentException.validateNotNull(model, "model");
        NullArgumentException.validateNotNull(model.getLocation(), "model#location");
        NullArgumentException.validateNotNull(model.getError(), "model#error");
        ErrorPage errorPage = new ErrorPage();
        errorPage.setLocation(model.getLocation());
        Integer errorCode = this.parseErrorCode(model.getError());
        if (errorCode != null) {
            errorPage.setErrorCode(errorCode.intValue());
        } else {
            errorPage.setExceptionType(model.getError());
        }
        return errorPage;
    }

    private Integer parseErrorCode(String errorCode) {
        try {
            return Integer.parseInt(errorCode);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void removeErrorPage(ErrorPageModel model) {
        Context context = this.findContext((Model)model);
        if (context == null) {
            throw new RemoveErrorPageException("cannot retrieve the associated context: " + model);
        }
        ErrorPage errorPage = this.createErrorPage(model);
        context.removeErrorPage(errorPage);
    }

    @Override
    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        LOG.debug("createResourceServlet( contextModel: {}, alias: {}, name: {})");
        return new TomcatResourceServlet(contextModel.getHttpContext(), contextModel.getContextName(), alias, name);
    }

    @Override
    public void addSecurityConstraintMapping(SecurityConstraintMappingModel secMapModel) {
        throw new UnsupportedOperationException("not yet implemented :(");
    }

    @Override
    public LifeCycle getContext(ContextModel model) {
        final Context context = this.findOrCreateContext(model);
        if (context == null) {
            throw new RemoveErrorPageException("cannot retrieve the associated context: " + model);
        }
        return new LifeCycle(){

            public void start() throws Exception {
                context.start();
            }

            public void stop() throws Exception {
                context.stop();
            }
        };
    }

    private void addServletMappings(Context context, String servletName, String[] urlPatterns) {
        NullArgumentException.validateNotNull(urlPatterns, "urlPatterns");
        for (String urlPattern : urlPatterns) {
            context.addServletMapping(urlPattern, servletName);
        }
    }

    private void addInitParameters(Wrapper wrapper, Map<String, String> initParameters) {
        NullArgumentException.validateNotNull(initParameters, "initParameters");
        NullArgumentException.validateNotNull(wrapper, "wrapper");
        for (Map.Entry<String, String> initParam : initParameters.entrySet()) {
            wrapper.addInitParameter(initParam.getKey(), initParam.getValue());
        }
    }

    private Context findOrCreateContext(Model model) {
        NullArgumentException.validateNotNull(model, "model");
        return this.findOrCreateContext(model.getContextModel());
    }

    private Context findOrCreateContext(ContextModel contextModel) {
        Context context = this.findContext(contextModel);
        if (context == null) {
            context = this.createContext(contextModel);
        }
        return context;
    }

    private Context createContext(ContextModel contextModel) {
        Bundle bundle = contextModel.getBundle();
        BundleContext bundleContext = BundleUtils.getBundleContext(bundle);
        Context context = this.m_server.addContext(contextModel.getContextParams(), this.getContextAttributes(bundleContext), contextModel.getContextName(), contextModel.getHttpContext(), contextModel.getAccessControllerContext(), contextModel.getContainerInitializers(), contextModel.getJettyWebXmlURL(), contextModel.getVirtualHosts(), contextModel.getConnectors(), this.m_server.getBasedir());
        context.setParentClassLoader(contextModel.getClassLoader());
        ServletContextManager.addContext((String)context.getPath(), (ServletContextManager.ServletContextWrapper)new TomcatServletContextWrapper(context, this.m_server.getHost()));
        LifecycleState state = context.getState();
        if (state != LifecycleState.STARTED && state != LifecycleState.STARTING && state != LifecycleState.STARTING_PREP) {
            LOG.debug("Registering ServletContext as service. ");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
            Dictionary headers = bundle.getHeaders();
            String version = (String)headers.get("Bundle-Version");
            if (version != null && version.length() > 0) {
                ((Dictionary)properties).put("osgi.web.version", version);
            }
            String webContextPath = (String)headers.get(WEB_CONTEXT_PATH);
            String webappContext = (String)headers.get("Webapp-Context");
            ServletContext servletContext = context.getServletContext();
            if ("/".equalsIgnoreCase(context.getPath()) && (webContextPath == null || webappContext == null)) {
                webContextPath = context.getPath();
            }
            String string = webContextPath = webContextPath != null ? webContextPath : webappContext;
            if (webContextPath != null && !webContextPath.startsWith("/")) {
                webContextPath = "/" + webContextPath;
            }
            if (webContextPath == null) {
                LOG.warn("osgi.web.contextpath couldn't be set, it's not configured");
            }
            ((Dictionary)properties).put("osgi.web.contextpath", webContextPath);
            this.servletContextService = bundleContext.registerService(ServletContext.class, (Object)servletContext, properties);
            LOG.debug("ServletContext registered as service. ");
        }
        this.m_contexts.put(contextModel.getHttpContext(), context);
        return context;
    }

    private Context findContext(ContextModel contextModel) {
        String contextName = contextModel.getContextName();
        return this.m_server.findContext(contextName);
    }

    private Context findContext(Model model) {
        return this.findContext(model.getContextModel());
    }

    private Map<String, Object> getContextAttributes(BundleContext bundleContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.contextAttributes != null) {
            attributes.putAll(this.contextAttributes);
        }
        attributes.put("osgi-bundlecontext", bundleContext);
        attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", bundleContext);
        return attributes;
    }
}

