/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.common.bi.BiJoinerComber;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.common.uni.InnerUniConstraintStream;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public abstract class InnerConstraintFactory<Solution_, Constraint_ extends Constraint>
implements ConstraintFactory {
    public <A> UniConstraintStream<A> forEach(Class<A> sourceClass) {
        UniConstraintStream stream = this.forEachIncludingNullVars(sourceClass);
        Predicate<A> nullityFilter = this.getNullityFilter(sourceClass);
        return nullityFilter == null ? stream : stream.filter(nullityFilter);
    }

    public <A> Predicate<A> getNullityFilter(Class<A> fromClass) {
        EntityDescriptor entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            return entityDescriptor.getHasNoNullVariables();
        }
        return null;
    }

    public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass, BiJoiner<A, A> ... joiners) {
        BiJoinerComber<A, A> joinerComber = BiJoinerComber.comb(joiners);
        joinerComber.addJoiner(this.buildLessThanId(sourceClass));
        return ((InnerUniConstraintStream)this.forEach(sourceClass)).join(this.forEach(sourceClass), joinerComber);
    }

    private <A> DefaultBiJoiner<A, A> buildLessThanId(Class<A> sourceClass) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        MemberAccessor planningIdMemberAccessor = ConfigUtils.findPlanningIdMemberAccessor(sourceClass, (MemberAccessorFactory)solutionDescriptor.getMemberAccessorFactory(), (DomainAccessType)solutionDescriptor.getDomainAccessType());
        if (planningIdMemberAccessor == null) {
            throw new IllegalArgumentException("The fromClass (" + sourceClass + ") has no member with a @" + PlanningId.class.getSimpleName() + " annotation, so the pairs cannot be made unique ([A,B] vs [B,A]).");
        }
        Function planningIdGetter = planningIdMemberAccessor.getGetterFunction();
        return (DefaultBiJoiner)Joiners.lessThan((Function)planningIdGetter);
    }

    public <A> UniConstraintStream<A> from(Class<A> fromClass) {
        UniConstraintStream stream = this.fromUnfiltered(fromClass);
        EntityDescriptor entityDescriptor = this.getSolutionDescriptor().findEntityDescriptor(fromClass);
        if (entityDescriptor != null && entityDescriptor.hasAnyGenuineVariables()) {
            Predicate predicate = entityDescriptor.getIsInitializedPredicate();
            stream = stream.filter(predicate);
        }
        return stream;
    }

    public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> ... joiners) {
        BiJoinerComber<A, A> joinerComber = BiJoinerComber.comb(joiners);
        joinerComber.addJoiner(this.buildLessThanId(fromClass));
        return ((InnerUniConstraintStream)this.from(fromClass)).join(this.from(fromClass), joinerComber);
    }

    public <A> void assertValidFromType(Class<A> fromType) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Set problemFactOrEntityClassSet = solutionDescriptor.getProblemFactOrEntityClassSet();
        boolean hasMatchingType = problemFactOrEntityClassSet.stream().anyMatch(factType -> fromType.isAssignableFrom((Class<?>)factType) || factType.isAssignableFrom(fromType));
        if (!hasMatchingType) {
            List canonicalClassNameList = problemFactOrEntityClassSet.stream().map(Class::getCanonicalName).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException("Cannot use class (" + fromType.getCanonicalName() + ") in a constraint stream as it is neither the same as, nor a superclass or superinterface of one of planning entities or problem facts.\nEnsure that all from(), join(), ifExists() and ifNotExists() building blocks only reference classes assignable from planning entities or problem facts (" + canonicalClassNameList + ") annotated on the planning solution (" + solutionDescriptor.getSolutionClass().getCanonicalName() + ").");
        }
    }

    public List<Constraint_> buildConstraints(ConstraintProvider constraintProvider) {
        Constraint[] constraints = constraintProvider.defineConstraints((ConstraintFactory)this);
        if (constraints == null) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not return null.\nMaybe return an empty array instead if there are no constraints.");
        }
        if (Arrays.stream(constraints).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the " + Constraint.class.getSimpleName() + " array.");
        }
        Map<String, List<Constraint>> constraintsPerIdMap = Arrays.stream(constraints).collect(Collectors.groupingBy(Constraint::getConstraintId));
        constraintsPerIdMap.forEach((? super K constraintId, ? super V duplicateConstraintList) -> {
            if (duplicateConstraintList.size() > 1) {
                throw new IllegalStateException("There are multiple constraints with the same ID (" + constraintId + ").");
            }
        });
        return Arrays.stream(constraints).map(c -> c).collect(Collectors.toList());
    }

    public abstract SolutionDescriptor<Solution_> getSolutionDescriptor();
}

