/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.tri;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.DefaultConstraintJustification;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintBuilder;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;

public interface InnerTriConstraintStream<A, B, C>
extends TriConstraintStream<A, B, C> {
    public static <A, B, C> QuadFunction<A, B, C, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, b, c, score) -> DefaultConstraintJustification.of((Score)score, (Object)a, (Object)b, (Object)c);
    }

    public static <A, B, C> TriFunction<A, B, C, Collection<?>> createDefaultIndictedObjectsMapping() {
        return List::of;
    }

    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    default public TriConstraintStream<A, B, C> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy((a, b, c) -> a, (a, b, c) -> b, (a, b, c) -> c);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalize(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalizeLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalizeBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> reward(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> rewardLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> rewardBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impact(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impactLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impactBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C, ?> impactConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToIntTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToLongTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, TriFunction<A, B, C, BigDecimal> var2, ScoreImpactType var3);

    default public Constraint penalize(String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint reward(String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint rewardConfigurable(String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    default public Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint impact(String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

