/**
 * h2spatial is a library that brings spatial support to the H2 Java database.
 *
 * h2spatial is distributed under GPL 3 license. It is produced by the "Atelier SIG"
 * team of the IRSTV Institute <http://www.irstv.fr/> CNRS FR 2488.
 *
 * Copyright (C) 2007-2014 IRSTV (FR CNRS 2488)
 *
 * h2patial is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * h2spatial is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * h2spatial. If not, see <http://www.gnu.org/licenses/>.
 *
 * For more information, please consult: <http://www.orbisgis.org/>
 * or contact directly:
 * info_at_ orbisgis.org
 */

package org.h2gis.h2spatial.internal.function.spatial.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;

import org.h2gis.h2spatialapi.DeterministicScalarFunction;

/**
 * Returns the first coordinate of a Geometry as a POINT, given that the
 * Geometry is a LINESTRING or a MULTILINESTRING containing only one
 * LINESTRING; Returns NULL for all other Geometries. 
 *
 * @author Nicolas Fortin
 */
public class ST_StartPoint extends DeterministicScalarFunction {

    /**
     * Default constructor
     */
    public ST_StartPoint() {
        addProperty(PROP_REMARKS, "Returns the first coordinate of a Geometry as a " +
                "POINT, given that the Geometry is a LINESTRING or a " +
                "MULTILINESTRING containing only one LINESTRING. " +
                "Returns NULL for all other Geometries. ");
    }

    @Override
    public String getJavaStaticMethod() {
        return "getStartPoint";
    }

    /**
     * @param geometry Geometry
     * @return The first coordinate of a Geometry as a POINT, given that the
     * Geometry is a LINESTRING or a MULTILINESTRING containing only one
     * LINESTRING; Returns NULL for all other Geometries. 
     */
    public static Geometry getStartPoint(Geometry geometry) {
        if (geometry instanceof MultiLineString) {
            if (geometry.getNumGeometries() == 1) {
                return ((LineString) geometry.getGeometryN(0)).getStartPoint();
            }
        } else if (geometry instanceof LineString) {
            return ((LineString) geometry).getStartPoint();

        }
        return null;
    }
}
