/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Cluster;
import org.ovirt.engine.sdk.decorators.ClusterNetwork;
import org.ovirt.engine.sdk.entities.Network;
import org.ovirt.engine.sdk.entities.Networks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterNetworks
extends CollectionDecorator<Network, Networks, ClusterNetwork> {
    private Cluster parent;

    public ClusterNetworks(HttpProxyBroker proxy, Cluster parent) {
        super(proxy, "networks");
        this.parent = parent;
    }

    @Override
    public List<ClusterNetwork> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Networks.class, ClusterNetwork.class);
    }

    @Override
    public ClusterNetwork get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Network.class, ClusterNetwork.class);
    }

    public List<ClusterNetwork> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Networks.class, ClusterNetwork.class);
    }

    public ClusterNetwork add(Network network) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, network, Network.class, ClusterNetwork.class);
    }
}

