/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.HostHooks;
import org.ovirt.engine.sdk.decorators.HostNICs;
import org.ovirt.engine.sdk.decorators.HostPermissions;
import org.ovirt.engine.sdk.decorators.HostStatistics;
import org.ovirt.engine.sdk.decorators.HostTags;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class Host
extends org.ovirt.engine.sdk.entities.Host {
    private HttpProxyBroker proxy;
    private HostHooks hostHooks;
    private HostNICs hostNICs;
    private HostTags hostTags;
    private HostPermissions hostPermissions;
    private HostStatistics hostStatistics;

    public Host(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    @Override
    public synchronized HostHooks getHooks() {
        if (this.hostHooks == null) {
            this.hostHooks = new HostHooks(this.proxy, this);
        }
        return this.hostHooks;
    }

    public synchronized HostNICs getHostNics() {
        if (this.hostNICs == null) {
            this.hostNICs = new HostNICs(this.proxy, this);
        }
        return this.hostNICs;
    }

    public synchronized HostTags getTags() {
        if (this.hostTags == null) {
            this.hostTags = new HostTags(this.proxy, this);
        }
        return this.hostTags;
    }

    public synchronized HostPermissions getPermissions() {
        if (this.hostPermissions == null) {
            this.hostPermissions = new HostPermissions(this.proxy, this);
        }
        return this.hostPermissions;
    }

    @Override
    public synchronized HostStatistics getStatistics() {
        if (this.hostStatistics == null) {
            this.hostStatistics = new HostStatistics(this.proxy, this);
        }
        return this.hostStatistics;
    }

    public Action install(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/install";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Action activate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/activate";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Host update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.Host.class, Host.class);
    }

    public Action fence(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/fence";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Action iscsidiscover(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsidiscover";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Action approve(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/approve";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Action iscsilogin(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/iscsilogin";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().delete(url, Response.class);
    }

    public Action deactivate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/deactivate";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }

    public Action commitnetconfig(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/commitnetconfig";
        return this.getProxy().action(url, action, Action.class, Action.class);
    }
}

