/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.User;
import org.ovirt.engine.sdk.decorators.UserTag;
import org.ovirt.engine.sdk.entities.Tag;
import org.ovirt.engine.sdk.entities.Tags;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class UserTags
extends CollectionDecorator<Tag, Tags, UserTag> {
    private User parent;

    public UserTags(HttpProxyBroker proxy, User parent) {
        super(proxy, "tags");
        this.parent = parent;
    }

    @Override
    public List<UserTag> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Tags.class, UserTag.class);
    }

    @Override
    public UserTag get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Tag.class, UserTag.class);
    }

    public List<UserTag> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Tags.class, UserTag.class);
    }

    public UserTag add(Tag tag) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, tag, Tag.class, UserTag.class);
    }
}

