/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenter;
import org.ovirt.engine.sdk.decorators.DataCenterQuota;
import org.ovirt.engine.sdk.entities.Quota;
import org.ovirt.engine.sdk.entities.Quotas;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class DataCenterQuotas
extends CollectionDecorator<Quota, Quotas, DataCenterQuota> {
    private DataCenter parent;

    public DataCenterQuotas(HttpProxyBroker proxy, DataCenter parent) {
        super(proxy, "quotas");
        this.parent = parent;
    }

    @Override
    public List<DataCenterQuota> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Quotas.class, DataCenterQuota.class);
    }

    @Override
    public DataCenterQuota get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Quota.class, DataCenterQuota.class);
    }

    public DataCenterQuota add(Quota quota) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, quota, Quota.class, DataCenterQuota.class);
    }
}

