/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.GroupRole;
import org.ovirt.engine.sdk.decorators.GroupRolePermit;
import org.ovirt.engine.sdk.entities.Permit;
import org.ovirt.engine.sdk.entities.Permits;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class GroupRolePermits
extends CollectionDecorator<Permit, Permits, GroupRolePermit> {
    private GroupRole parent;

    public GroupRolePermits(HttpProxyBroker proxy, GroupRole parent) {
        super(proxy, "permits");
        this.parent = parent;
    }

    @Override
    public List<GroupRolePermit> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Permits.class, GroupRolePermit.class);
    }

    @Override
    public GroupRolePermit get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Permit.class, GroupRolePermit.class);
    }

    public List<GroupRolePermit> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Permits.class, GroupRolePermit.class);
    }

    public GroupRolePermit add(Permit permit) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, permit, Permit.class, GroupRolePermit.class);
    }
}

