/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Group;
import org.ovirt.engine.sdk.decorators.GroupRole;
import org.ovirt.engine.sdk.entities.Role;
import org.ovirt.engine.sdk.entities.Roles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class GroupRoles
extends CollectionDecorator<Role, Roles, GroupRole> {
    private Group parent;

    public GroupRoles(HttpProxyBroker proxy, Group parent) {
        super(proxy, "roles");
        this.parent = parent;
    }

    @Override
    public List<GroupRole> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Roles.class, GroupRole.class);
    }

    @Override
    public GroupRole get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Role.class, GroupRole.class);
    }

    public List<GroupRole> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Roles.class, GroupRole.class);
    }

    public GroupRole add(Role role) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, role, Role.class, GroupRole.class);
    }
}

