/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.StorageDomain;
import org.ovirt.engine.sdk.decorators.StorageDomainVM;
import org.ovirt.engine.sdk.entities.VM;
import org.ovirt.engine.sdk.entities.VMs;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class StorageDomainVMs
extends CollectionDecorator<VM, VMs, StorageDomainVM> {
    private StorageDomain parent;

    public StorageDomainVMs(HttpProxyBroker proxy, StorageDomain parent) {
        super(proxy, "vms");
        this.parent = parent;
    }

    @Override
    public List<StorageDomainVM> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VMs.class, StorageDomainVM.class);
    }

    @Override
    public StorageDomainVM get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VM.class, StorageDomainVM.class);
    }

    public List<StorageDomainVM> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, VMs.class, StorageDomainVM.class);
    }
}

