/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Template;
import org.ovirt.engine.sdk.decorators.TemplateDisk;
import org.ovirt.engine.sdk.entities.Disk;
import org.ovirt.engine.sdk.entities.Disks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class TemplateDisks
extends CollectionDecorator<Disk, Disks, TemplateDisk> {
    private Template parent;

    public TemplateDisks(HttpProxyBroker proxy, Template parent) {
        super(proxy, "disks");
        this.parent = parent;
    }

    @Override
    public List<TemplateDisk> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Disks.class, TemplateDisk.class);
    }

    @Override
    public TemplateDisk get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Disk.class, TemplateDisk.class);
    }

    public List<TemplateDisk> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Disks.class, TemplateDisk.class);
    }
}

