/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.User;
import org.ovirt.engine.sdk.decorators.UserRole;
import org.ovirt.engine.sdk.entities.Role;
import org.ovirt.engine.sdk.entities.Roles;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class UserRoles
extends CollectionDecorator<Role, Roles, UserRole> {
    private User parent;

    public UserRoles(HttpProxyBroker proxy, User parent) {
        super(proxy, "roles");
        this.parent = parent;
    }

    @Override
    public List<UserRole> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Roles.class, UserRole.class);
    }

    @Override
    public UserRole get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Role.class, UserRole.class);
    }

    public List<UserRole> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Roles.class, UserRole.class);
    }

    public UserRole add(Role role) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, role, Role.class, UserRole.class);
    }
}

