/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VM;
import org.ovirt.engine.sdk.decorators.VMNIC;
import org.ovirt.engine.sdk.entities.NIC;
import org.ovirt.engine.sdk.entities.Nics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VMNICs
extends CollectionDecorator<NIC, Nics, VMNIC> {
    private VM parent;

    public VMNICs(HttpProxyBroker proxy, VM parent) {
        super(proxy, "nics");
        this.parent = parent;
    }

    @Override
    public List<VMNIC> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Nics.class, VMNIC.class);
    }

    @Override
    public VMNIC get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, NIC.class, VMNIC.class);
    }

    public List<VMNIC> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        String url = new UrlBuilder(this.parent.getHref() + "/" + this.getName()).add("max", max, UrlParameterType.MATRIX).build();
        return this.list(url, Nics.class, VMNIC.class);
    }

    public VMNIC add(NIC nic) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.getProxy().add(url, nic, NIC.class, VMNIC.class);
    }
}

