/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderUtils;
import org.ovirt.engine.sdk.utils.HttpResponseHelper;
import org.ovirt.engine.sdk.web.ConnectionsPool;

public class HttpProxy {
    private static int BAD_REQUEST = 400;
    private static String[] STATIC_HEADERS = new String[]{"Content-type:application/xml"};
    private ConnectionsPool pool;
    private List<Header> staticHeaders;
    private boolean persistentAuth = true;
    private boolean insecure = false;
    private boolean filter = false;
    private boolean debug = false;

    public HttpProxy(ConnectionsPool pool, boolean persistent_auth, boolean insecure, boolean filter, boolean debug) {
        this.pool = pool;
        this.staticHeaders = HttpHeaderUtils.toHeaders(STATIC_HEADERS);
        this.persistentAuth = persistent_auth;
        this.insecure = insecure;
        this.filter = filter;
        this.debug = debug;
    }

    public URL getUrl() {
        return this.pool.getUrl();
    }

    public String execute(HttpUriRequest request, List<Header> headers, Boolean last) throws IOException, ClientProtocolException, ServerException {
        this.injectHeaders(request, headers);
        HttpResponse response = this.pool.execute(request, (HttpContext)new BasicHttpContext());
        if (response.getStatusLine().getStatusCode() < BAD_REQUEST) {
            return HttpResponseHelper.getEntity(response.getEntity());
        }
        throw new ServerException(response);
    }

    private void injectHeaders(HttpUriRequest request, List<Header> headers) {
        if (headers != null && !headers.isEmpty()) {
            request.setHeaders(headers.toArray(new Header[headers.size()]));
        }
        for (Header header : this.staticHeaders) {
            if (header.getName().equals("Content-type") && request instanceof HttpDelete) continue;
            request.addHeader(header);
        }
        request.addHeader("Filter", Boolean.toString(this.isFilter()));
    }

    public boolean isPersistentAuth() {
        return this.persistentAuth;
    }

    public void setPersistentAuth(boolean persistentAuth) {
        this.persistentAuth = persistentAuth;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public void setInsecure(boolean insecure) {
        this.insecure = insecure;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void shutdown() {
        this.pool.getConnectionManager().shutdown();
    }
}

