/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.VMCdRoms;
import org.ovirt.engine.sdk.decorators.VMDisks;
import org.ovirt.engine.sdk.decorators.VMNICs;
import org.ovirt.engine.sdk.decorators.VMPermissions;
import org.ovirt.engine.sdk.decorators.VMReportedDevices;
import org.ovirt.engine.sdk.decorators.VMSnapshots;
import org.ovirt.engine.sdk.decorators.VMStatistics;
import org.ovirt.engine.sdk.decorators.VMTags;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class VM
extends org.ovirt.engine.sdk.entities.VM {
    private HttpProxyBroker proxy;
    private VMPermissions vMPermissions;
    private VMReportedDevices vMReportedDevices;
    private VMTags vMTags;
    private VMSnapshots vMSnapshots;
    private VMStatistics vMStatistics;
    private VMDisks vMDisks;
    private VMNICs vMNICs;
    private VMCdRoms vMCdRoms;

    public VM(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    public synchronized VMPermissions getPermissions() {
        if (this.vMPermissions == null) {
            this.vMPermissions = new VMPermissions(this.proxy, this);
        }
        return this.vMPermissions;
    }

    @Override
    public synchronized VMReportedDevices getReportedDevices() {
        if (this.vMReportedDevices == null) {
            this.vMReportedDevices = new VMReportedDevices(this.proxy, this);
        }
        return this.vMReportedDevices;
    }

    @Override
    public synchronized VMTags getTags() {
        if (this.vMTags == null) {
            this.vMTags = new VMTags(this.proxy, this);
        }
        return this.vMTags;
    }

    @Override
    public synchronized VMSnapshots getSnapshots() {
        if (this.vMSnapshots == null) {
            this.vMSnapshots = new VMSnapshots(this.proxy, this);
        }
        return this.vMSnapshots;
    }

    @Override
    public synchronized VMStatistics getStatistics() {
        if (this.vMStatistics == null) {
            this.vMStatistics = new VMStatistics(this.proxy, this);
        }
        return this.vMStatistics;
    }

    @Override
    public synchronized VMDisks getDisks() {
        if (this.vMDisks == null) {
            this.vMDisks = new VMDisks(this.proxy, this);
        }
        return this.vMDisks;
    }

    @Override
    public synchronized VMNICs getNics() {
        if (this.vMNICs == null) {
            this.vMNICs = new VMNICs(this.proxy, this);
        }
        return this.vMNICs;
    }

    @Override
    public synchronized VMCdRoms getCdRoms() {
        if (this.vMCdRoms == null) {
            this.vMCdRoms = new VMCdRoms(this.proxy, this);
        }
        return this.vMCdRoms;
    }

    public Action suspend(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/suspend";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action suspend(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/suspend";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public VM update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.VM.class, VM.class);
    }

    public Action stop(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/stop";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action stop(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/stop";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action cancelmigration(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/cancelmigration";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action export(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/export";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action export(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/export";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action detach(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/detach";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action detach(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/detach";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action ticket(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/ticket";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action ticket(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/ticket";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action start(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/start";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action start(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/start";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action migrate(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/migrate";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action migrate(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/migrate";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).add("async", async, UrlParameterType.MATRIX).build();
        return this.getProxy().delete(url, action, Action.class, Response.class, headers);
    }

    public Action move(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/move";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action move(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/move";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action shutdown(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/shutdown";
        List<Header> headers = new HttpHeaderBuilder().build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action shutdown(Action action, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/shutdown";
        List<Header> headers = new HttpHeaderBuilder().add("Correlation-Id", correlationId).build();
        url = new UrlBuilder(url).build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }
}

