/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.utils;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;

public class UrlHelper {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static String SLASH = "/";
    private URL url;
    private String effectiveUri;
    private String root;

    public UrlHelper(URL url) {
        this.url = url;
        this.root = url.getPath();
        this.effectiveUri = url.toString().replace(this.root, "");
    }

    public String combine(String path) {
        if (path.startsWith(this.root)) {
            return this.effectiveUri + path;
        }
        return this.effectiveUri + SLASH + this.root + path;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getRoot() {
        return this.root;
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }
}

