/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.mapping.Mapper;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.utils.UrlHelper;
import org.ovirt.engine.sdk.web.HttpDelete;
import org.ovirt.engine.sdk.web.HttpProxy;

public class HttpProxyBroker {
    private HttpProxy proxy;
    private UrlHelper urlHelper;

    public HttpProxyBroker(HttpProxy proxy) {
        this.proxy = proxy;
        this.urlHelper = new UrlHelper(proxy.getUrl());
    }

    public <F, T> T update(String url, F entity, Class<F> from, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.update(url, entity, from, to, null);
    }

    public <F, T> T update(String url, F entity, Class<F> from, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        HttpPut httpput = new HttpPut(this.urlHelper.combine(url));
        String xmlReq = SerializationHelper.marshall(from, entity);
        StringEntity httpentity = new StringEntity(xmlReq);
        httpput.setEntity((HttpEntity)httpentity);
        String xmlRes = this.proxy.execute((HttpUriRequest)httpput, headers, null);
        return this.unmarshall(from, to, xmlRes);
    }

    public <F, T> T action(String url, F entity, Class<F> from, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.add(url, entity, from, to, null);
    }

    public <F, T> T action(String url, F entity, Class<F> from, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        return this.add(url, entity, from, to, headers);
    }

    public <F, T> T add(String url, F entity, Class<F> from, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.add(url, entity, from, to, null);
    }

    public <F, T> T add(String url, F entity, Class<F> from, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        HttpPost httpost = new HttpPost(this.urlHelper.combine(url));
        String xmlReq = SerializationHelper.marshall(from, entity);
        StringEntity httpentity = new StringEntity(xmlReq);
        httpost.setEntity((HttpEntity)httpentity);
        String xmlRes = this.proxy.execute((HttpUriRequest)httpost, headers, null);
        return this.unmarshall(from, to, xmlRes);
    }

    public <F, T> T delete(String url, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.delete(url, null, null, to, null);
    }

    public <F, T> T delete(String url, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        return this.delete(url, null, null, to, headers);
    }

    public <F, T> T delete(String url, F entity, Class<F> from, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.delete(url, entity, from, to, null);
    }

    public <F, T> T delete(String url, F entity, Class<F> from, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        HttpDelete httdelete = new HttpDelete(this.urlHelper.combine(url));
        if (entity != null && from != null) {
            String xmlReq = SerializationHelper.marshall(from, entity);
            StringEntity httpentity = new StringEntity(xmlReq);
            httdelete.setEntity((HttpEntity)httpentity);
        }
        String xmlRes = this.proxy.execute((HttpUriRequest)httdelete, headers, null);
        return SerializationHelper.unmarshall(to, xmlRes);
    }

    public <F, T> T get(String url, Class<F> from, Class<T> to, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        HttpGet httpget = new HttpGet(this.urlHelper.combine(url));
        String xmlRes = this.proxy.execute((HttpUriRequest)httpget, headers, null);
        return this.unmarshall(from, to, xmlRes);
    }

    public <F, T> T get(String url, Class<F> from, Class<T> to) throws IOException, ClientProtocolException, ServerException {
        return this.get(url, from, to, null);
    }

    public <F> F get(String url, Class<F> from) throws IOException, ClientProtocolException, ServerException {
        HttpGet httpget = new HttpGet(this.urlHelper.combine(url));
        String xmlRes = this.proxy.execute((HttpUriRequest)httpget, null, null);
        return SerializationHelper.unmarshall(from, xmlRes);
    }

    public String get(String url) throws IOException, ClientProtocolException, ServerException {
        return this.get(url, new ArrayList<Header>());
    }

    public String get(String url, List<Header> headers) throws IOException, ClientProtocolException, ServerException {
        HttpGet httpget = new HttpGet(this.urlHelper.combine(url));
        return this.proxy.execute((HttpUriRequest)httpget, headers, null);
    }

    public void setFilter(boolean filter) {
        this.proxy.setFilter(filter);
    }

    public void setDebug(boolean debug) {
        this.proxy.setDebug(debug);
    }

    public void setInsecure(boolean insecure) {
        this.proxy.setInsecure(insecure);
    }

    public void setPersistentAuth(boolean persistentAuth) {
        this.proxy.setPersistentAuth(persistentAuth);
    }

    public boolean isPersistentAuth() {
        return this.proxy.isPersistentAuth();
    }

    public boolean isInsecure() {
        return this.proxy.isInsecure();
    }

    public boolean isFilter() {
        return this.proxy.isFilter();
    }

    public boolean isDebug() {
        return this.proxy.isDebug();
    }

    public String getRoot() {
        return this.urlHelper.getRoot();
    }

    private <F, T> T unmarshall(Class<F> from, Class<T> to, String xml) {
        F res = SerializationHelper.unmarshall(from, xml);
        if (from.equals(to)) {
            return (T)res;
        }
        return Mapper.map(res, to, this);
    }
}

