/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.common;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.Decorator;
import org.ovirt.engine.sdk.entities.BaseResource;
import org.ovirt.engine.sdk.entities.BaseResources;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.mapping.Mapper;
import org.ovirt.engine.sdk.utils.CollectionUtils;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public abstract class CollectionDecorator<R extends BaseResource, Q extends BaseResources, Z extends R>
extends Decorator {
    private String NAME;
    protected static final String SLASH = "/";

    public CollectionDecorator(HttpProxyBroker proxy, String urlCollectionName) {
        super(proxy);
        this.NAME = urlCollectionName;
    }

    public abstract List<Z> list() throws ClientProtocolException, ServerException, IOException;

    public abstract Z get(UUID var1) throws ClientProtocolException, ServerException, IOException;

    public Z get(String name) throws ClientProtocolException, ServerException, IOException {
        List<Z> collection = this.list();
        return CollectionUtils.getItemByName(name, collection);
    }

    protected List<Z> list(String url, Class<Q> from, Class<Z> to) throws ClientProtocolException, ServerException, IOException {
        return this.list(url, from, to, null);
    }

    protected List<Z> list(String url, Class<Q> from, Class<Z> to, List<Header> headers) throws ClientProtocolException, ServerException, IOException {
        String resXml = this.getProxy().get(url, headers);
        return this.unmarshall(from, to, resXml);
    }

    private List<Z> unmarshall(Class<Q> from, Class<Z> to, String xml) {
        ArrayList<Z> toColl = new ArrayList<Z>();
        BaseResources collObj = (BaseResources)SerializationHelper.unmarshall(from, xml);
        List<R> fromColl = this.fetchCollection(collObj);
        if (fromColl != null && !fromColl.isEmpty()) {
            for (BaseResource res : fromColl) {
                toColl.add(Mapper.map(res, to, this.getProxy()));
            }
        }
        return toColl;
    }

    private List<R> fetchCollection(Q collection) {
        for (Method m : collection.getClass().getMethods()) {
            if (!m.getName().startsWith("get") || !m.getReturnType().equals(List.class)) continue;
            try {
                return (List)m.invoke(collection, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected String getName() {
        return this.NAME;
    }
}

